package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

public class ContextMapper extends HashMap<String, ContextDef> {

	private static final long serialVersionUID = 2159682308502487305L;

	private static final Log log = LogFactory.getLog(ContextMapper.class);

	private Type token = new TypeToken<List<ContextDef>>() {}.getType();

	@SuppressWarnings("unchecked")
	public void fromJson(final String json) {
		super.clear();
		if ((json != null) && !json.isEmpty()) {
			for (ContextDef def : (List<ContextDef>) new Gson().fromJson(json, token)) {
				super.put(def.getId(), def);
			}
		} else {
			log.warn("unable to inizialize, empty source json string");
		}
	}

	@Override
	public String toString() {
		return new Gson().toJson(Lists.newArrayList(this.values()));
	}

}
