package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class EntityLinkTable extends HashMap<Type, HashMap<RelType, LinkDescriptor>> {

	private static final long serialVersionUID = -5045143790736657223L;

	public Collection<LinkDescriptor> getDescriptors(final Type source) {
		return super.get(source).values();
	}

	public LinkDescriptor getDescriptor(final Type type, final RelType relType) {
		return super.get(type).get(relType);
	}

	public Set<String> getFilter(final Type type, final RelType relType) {
		final LinkDescriptor ld = getDescriptor(type, relType);
		return ld != null ? ld.getFields() : new HashSet<String>();
	}
}
