/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfigLoader;
import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupBuildRootsMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private DedupConfig dedupConf;
    private final Set<String> entityNames = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Lists.newArrayList((Object[])TypeProtos.Type.values()), (Function)new Function<TypeProtos.Type, String>(){

        public String apply(TypeProtos.Type t) {
            return t.toString();
        }
    }));

    protected void setup(Mapper.Context context) {
        this.dedupConf = DedupConfigLoader.load(context.getConfiguration().get("dedup.wf.conf"));
        System.out.println("dedup buildRoots mapper\nwf conf: " + this.dedupConf.toString());
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap dedupRels = value.getFamilyMap(Bytes.toBytes((String)RelTypeProtos.RelType.dedupRel.toString()));
        if (dedupRels != null && !dedupRels.isEmpty()) {
            if (!DedupRootUtils.isRoot(rowkey)) {
                Text rootId = this.findRoot(dedupRels);
                context.getCounter(this.dedupConf.getEntityName(), "merged").increment(1L);
                for (String family : this.dedupConf.getRootBuilderFamilies()) {
                    NavigableMap map = value.getFamilyMap(Bytes.toBytes((String)family));
                    if (map == null || map.isEmpty()) continue;
                    if (this.entityNames.contains(family)) {
                        byte[] body = UpdateMerger.mergeBodyUpdates(map);
                        context.write((Object)rootId, (Object)new ImmutableBytesWritable(body));
                        continue;
                    }
                    for (byte[] o : map.values()) {
                        if (!this.isRelMarkedDeleted(context, o)) {
                            context.write((Object)rootId, (Object)new ImmutableBytesWritable(o));
                            continue;
                        }
                        context.getCounter(family, "rel marked deleted").increment(1L);
                    }
                }
            } else {
                context.getCounter(this.dedupConf.getEntityName(), "root").increment(1L);
            }
        } else {
            context.getCounter(this.dedupConf.getEntityName(), "not in duplicate group").increment(1L);
        }
    }

    protected boolean checkHack(byte[] rowkey, byte[] rootId, String family) {
        return this.dedupConf.getEntityName().equals(TypeProtos.Type.result.toString()) && family.equals(RelTypeProtos.RelType.personResult.toString()) && !rootId.equals(DedupRootUtils.newIdBytes(new String(rowkey), this.dedupConf.getDedupRun()));
    }

    private boolean isRelMarkedDeleted(Mapper.Context context, byte[] o) {
        try {
            OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])o);
            return oaf.getKind().equals((Object)KindProtos.Kind.relation) && oaf.getDataInfo().getDeletedbyinference();
        }
        catch (InvalidProtocolBufferException e) {
            context.getCounter("error", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return true;
        }
    }

    private Text findRoot(Map<byte[], byte[]> dedupRels) {
        return new Text((byte[])Iterables.getOnlyElement(dedupRels.keySet()));
    }
}

