/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase;

import eu.dnetlib.data.mapreduce.hbase.index.PrepareFeedJob;
import eu.dnetlib.data.proto.TypeProtos;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Text;

public class OafRowDecoder {
    private int type;
    private String id;

    public static OafRowDecoder decode(Text key) throws IllegalArgumentException {
        return new OafRowDecoder(key);
    }

    public static OafRowDecoder decode(ImmutableBytesWritable key) throws IllegalArgumentException {
        return new OafRowDecoder(new Text(key.copyBytes()));
    }

    private OafRowDecoder(Text key) throws IllegalArgumentException {
        String rowKey = key.toString();
        int pos = rowKey.indexOf((char)PrepareFeedJob.bSEPARATOR[0]);
        try {
            this.type = Integer.parseInt(rowKey.substring(0, pos));
            this.id = rowKey.substring(pos + 1);
        }
        catch (Exception e) {
            this.type = -1;
            this.id = null;
        }
    }

    public boolean isValid() {
        return this.id != null && this.type > 0;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    public TypeProtos.Type getType() {
        if (this.type > 0) {
            return TypeProtos.Type.valueOf((int)this.type);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }
}

