/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupPersonMapper;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupPersonReducer;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfigLoader;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class DedupPersonJob
extends AbstractHBaseMapReduceJob {
    @Override
    public Job setJobDetails(Job job, Properties p) {
        this.initJob(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.setOutputFormatClass(TableOutputFormat.class);
        job.setNumReduceTasks(1000);
        job.getConfiguration().setBoolean("mapred.compress.map.output", true);
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
        job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);
        job.getConfiguration().set("hbase.mapred.outputtable", p.getProperty("hbase.mapred.outputtable"));
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(500);
        scan.setCacheBlocks(false);
        DedupConfig dedupConfig = DedupConfigLoader.load(p.getProperty("dedup.wf.conf"));
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)dedupConfig.getEntityId())));
        return scan;
    }

    private void initJob(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, DedupPersonMapper.class, Text.class, ImmutableBytesWritable.class, (Job)job);
            TableMapReduceUtil.initTableReducerJob((String)sourceTable, DedupPersonReducer.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

