/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup.config;

import com.google.gson.Gson;
import eu.dnetlib.data.proto.TypeProtos;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.util.Bytes;

public class DedupConfig {
    private TypeProtos.Type entityType;
    private String orderField;
    private List<String> rootBuilderFamilies;
    private Set<String> skipList;
    private String dedupRun;
    private double threshold;

    public DedupConfig(TypeProtos.Type entityType, String orderField, List<String> rootBuilderFamilies, String dedupRun, double threshold, Set<String> skipList) {
        this.entityType = entityType;
        this.orderField = orderField;
        this.rootBuilderFamilies = rootBuilderFamilies;
        this.dedupRun = dedupRun.contains("'") ? dedupRun.replaceAll("'", "") : dedupRun;
        this.threshold = threshold;
        this.skipList = skipList;
    }

    public TypeProtos.Type getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.getEntityType().toString();
    }

    public byte[] getEntityNameBytes() {
        return Bytes.toBytes((String)this.getEntityType().toString());
    }

    public String getEntityId() {
        return Integer.toString(this.getEntityType().getNumber());
    }

    public String getOrderField() {
        return this.orderField;
    }

    public List<String> getRootBuilderFamilies() {
        return this.rootBuilderFamilies;
    }

    public String getDedupRun() {
        return this.dedupRun;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public Set<String> getSkipList() {
        return this.skipList;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

