/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.OafRowDecoder;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityLinkTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.IndexConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.mapreduce.util.UpdateMerger;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

public class PrepareFeedMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private EntityLinkTable entityLinkTable;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        String json = context.getConfiguration().get("index.entity.links");
        System.out.println("index.entity.links:\n" + json);
        this.entityLinkTable = IndexConfig.load(json).getLinkMap();
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        String keyOut = new String(keyIn.copyBytes());
        OafRowDecoder decoder = OafRowDecoder.decode(keyIn);
        if (!decoder.isValid()) {
            System.err.println("invalid key: " + keyOut);
        } else if (decoder.hasType()) {
            TypeProtos.Type type = decoder.getType();
            byte[] body = UpdateMerger.mergeBodyUpdates(result.getFamilyMap(Bytes.toBytes((String)type.toString())));
            if (this.isValid(body)) {
                OafProtos.Oaf oaf = this.decodeProto(context, body);
                if (!this.deletedByInference(oaf)) {
                    this.emit(keyOut, context, body);
                    this.incrementCounter(context, KindProtos.Kind.entity.toString(), type.toString(), 1);
                } else {
                    this.incrementCounter(context, "deleted by inference", type.toString(), 1);
                }
                for (LinkDescriptor ld : this.entityLinkTable.getDescriptors(type)) {
                    this.emitRel(oaf, context, result, type, ld.getRelType(), ld.getTarget(), ld.isChild());
                }
            } else {
                this.incrementCounter(context, "missing body", type.toString(), 1);
            }
        } else {
            throw new IllegalStateException("unknow row type: " + keyOut);
        }
    }

    private void emitRel(OafProtos.Oaf body, Mapper.Context context, Result result, TypeProtos.Type source, RelTypeProtos.RelType relType, TypeProtos.Type target, boolean isChild) throws IOException, InterruptedException {
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation);
        NavigableMap columnMap = result.getFamilyMap(Bytes.toBytes((String)relType.toString()));
        if (this.isValid(columnMap)) {
            for (Map.Entry e : columnMap.entrySet()) {
                OafProtos.Oaf decodedOaf = this.decodeProto(context, (byte[])e.getValue());
                if (!this.deletedByInference(decodedOaf)) {
                    OafProtos.OafRel.Builder relBuilder = OafProtos.OafRel.newBuilder((OafProtos.OafRel)decodedOaf.getRel());
                    relBuilder.setCachedTarget(body.getEntity());
                    if (relType.equals((Object)RelTypeProtos.RelType.dedupRel) && this.isDedupSelf((OafProtos.OafRelOrBuilder)relBuilder)) {
                        System.out.println("avoid to emit dedup self: " + relBuilder.getSource());
                        continue;
                    }
                    OafProtos.OafRel oafRel = relBuilder.setRelType(relType).setChild(isChild).build();
                    this.emit(oafRel.getTarget(), context, this.merge(oafBuilder, decodedOaf).setRel(oafRel).build().toByteArray());
                    continue;
                }
                this.incrementCounter(context, "deleted by inference", relType.toString(), 1);
            }
            this.incrementCounter(context, source.toString(), relType.toString(), columnMap.size());
        } else {
            this.incrementCounter(context, source.toString(), relType.toString() + "_empty", 1);
        }
    }

    protected String patchTargetId(TypeProtos.Type target, String id) {
        return id.replaceFirst("^.*\\|", target.getNumber() + "|");
    }

    private OafProtos.Oaf.Builder merge(OafProtos.Oaf.Builder builder, OafProtos.Oaf prototype) {
        return builder.setDataInfo(prototype.getDataInfo()).setTimestamp(prototype.getTimestamp());
    }

    private boolean isDedupSelf(OafProtos.OafRelOrBuilder rel) {
        return rel.getSource().contains(rel.getTarget());
    }

    private boolean isValid(Map<byte[], byte[]> columnMap) {
        return columnMap != null && !columnMap.isEmpty();
    }

    private boolean isValid(byte[] body) {
        return body != null && body.length > 0;
    }

    private boolean deletedByInference(OafProtos.Oaf oaf) {
        return oaf.getDataInfo().getDeletedbyinference();
    }

    private OafProtos.Oaf decodeProto(Mapper.Context context, byte[] body) {
        try {
            return OafProtos.Oaf.parseFrom((byte[])body);
        }
        catch (InvalidProtocolBufferException e) {
            context.getCounter("decodeProto", ((Object)((Object)e)).getClass().getName()).increment(1L);
            return null;
        }
    }

    private void emit(String key, Mapper.Context context, byte[] bytes) throws IOException, InterruptedException {
        Text keyOut = new Text(key);
        context.write((Object)keyOut, (Object)new ImmutableBytesWritable(bytes));
    }

    protected byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private void incrementCounter(Mapper.Context context, String k, String t, int n) {
        this.getCounter(context, k, t).increment((long)n);
    }

    private Counter getCounter(Mapper.Context context, String k, String t) {
        return context.getCounter(k, t);
    }
}

