/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.reset;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.HBaseTableUtils;
import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.proto.DataInfoProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class HBaseResetMapper
extends TableMapper<ImmutableBytesWritable, Mutation> {
    private static final boolean WRITE_TO_WAL = false;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        String table = context.getConfiguration().get("hbase.source.table").trim();
        System.out.println("I start to reset table " + table);
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        byte[] bKey = key.copyBytes();
        if (DedupRootUtils.isRoot(new String(bKey))) {
            this.deleteRow(key, context);
            return;
        }
        for (KeyValue kv : value.list()) {
            if (Bytes.toString((byte[])kv.getQualifier()).equals("body") || this.isColumn(kv.getFamily())) {
                OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])kv.getValue());
                if (!this.isColumnToUpdate(oaf)) continue;
                this.updateColumn(key, kv, (GeneratedMessage)this.resetOaf(oaf), context);
                continue;
            }
            if (!this.isColumnToDelete(kv)) continue;
            this.deleteColumn(key, kv, context);
        }
    }

    private boolean isColumn(byte[] family) {
        try {
            String s = Bytes.toString((byte[])family);
            return !s.equals(RelTypeProtos.RelType.similarRel.toString()) && !s.equals(RelTypeProtos.RelType.dedupRel.toString()) && !HBaseTableUtils.VolatileColumnFamily.isVolatile(s) && RelTypeProtos.RelType.valueOf((String)s) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isColumnToUpdate(OafProtos.Oaf oaf) {
        return oaf.getDataInfo().hasDeletedbyinference() && oaf.getDataInfo().getDeletedbyinference();
    }

    private OafProtos.Oaf resetOaf(OafProtos.Oaf oaf) {
        DataInfoProtos.DataInfo.Builder dataInfoBuilder = DataInfoProtos.DataInfo.newBuilder((DataInfoProtos.DataInfo)oaf.getDataInfo());
        dataInfoBuilder.setDeletedbyinference(false).setInferenceprovenance("");
        OafProtos.Oaf.Builder oafBuilder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf);
        oafBuilder.setDataInfo(dataInfoBuilder);
        return oafBuilder.build();
    }

    private boolean isColumnToDelete(KeyValue kv) throws InvalidProtocolBufferException {
        String cf = Bytes.toString((byte[])kv.getFamily());
        if (cf.equals(RelTypeProtos.RelType.dedupRel.toString()) || cf.equals(RelTypeProtos.RelType.similarRel.toString()) || HBaseTableUtils.VolatileColumnFamily.isVolatile(cf)) {
            return true;
        }
        OafProtos.Oaf oaf = OafProtos.Oaf.parseFrom((byte[])kv.getValue());
        return oaf.getDataInfo().hasInferred() && oaf.getDataInfo().getInferred();
    }

    private void updateColumn(ImmutableBytesWritable key, KeyValue col, GeneratedMessage newValue, Mapper.Context context) throws IOException, InterruptedException {
        byte[] bKey = key.copyBytes();
        Put put = new Put(bKey);
        put.add(col.getFamily(), col.getQualifier(), newValue.toByteArray());
        put.setWriteToWAL(false);
        context.write((Object)key, (Object)put);
        context.getCounter("reset job", "update body").increment(1L);
    }

    private void deleteRow(ImmutableBytesWritable key, Mapper.Context context) throws IOException, InterruptedException {
        byte[] bKey = key.copyBytes();
        Delete d = new Delete(bKey);
        d.setWriteToWAL(false);
        context.write((Object)key, (Object)d);
        context.getCounter("reset job", "delete row").increment(1L);
    }

    private void deleteColumn(ImmutableBytesWritable key, KeyValue col, Mapper.Context context) throws IOException, InterruptedException {
        byte[] bKey = key.copyBytes();
        Delete d = new Delete(bKey);
        d.deleteColumns(col.getFamily(), col.getQualifier());
        d.setWriteToWAL(false);
        context.write((Object)key, (Object)d);
        context.getCounter("reset job", "delete column").increment(1L);
    }
}

