/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

public class DedupRootUtils {
    public static final String ROOT = "dedup_wf";

    public static String dedupPrefix(String dedupRun) {
        return "|dedup_wf_" + dedupRun + "::";
    }

    public static String newId(String id, String dedupRun) {
        if (dedupRun == null || dedupRun.length() != 3) {
            throw new IllegalArgumentException("wrong dedupRun param");
        }
        return id.replaceFirst("\\|.*\\:\\:", DedupRootUtils.dedupPrefix(dedupRun));
    }

    public static byte[] newIdBytes(String s, String dedupRun) {
        return DedupRootUtils.newId(s, dedupRun).getBytes();
    }

    public static byte[] newIdBytes(ByteBuffer b, String dedupRun) {
        return DedupRootUtils.newId(new String(b.array()), dedupRun).getBytes();
    }

    public static boolean isRoot(String s) {
        return s.contains(ROOT);
    }

    public static boolean isRoot(ImmutableBytesWritable s) {
        return DedupRootUtils.isRoot(s.copyBytes());
    }

    public static boolean isRoot(byte[] s) {
        return DedupRootUtils.isRoot(new String(s));
    }
}

