/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.hbase.dedup.OafEntityMerger;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfigLoader;
import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafImporter;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;

public class DedupBuildRootsReducer
extends TableReducer<Text, ImmutableBytesWritable, ImmutableBytesWritable> {
    private DedupConfig dedupConf;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        super.setup(context);
        this.dedupConf = DedupConfigLoader.load(context.getConfiguration().get("dedup.wf.conf"));
        System.out.println("dedup buildRoots reducer\nwf conf: " + this.dedupConf.toString());
    }

    protected void reduce(Text key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (!DedupRootUtils.isRoot(key.toString())) {
            System.err.println("aborting DedupBuildRootsReducer, found non-root key: " + key);
            context.getCounter("DedupBuildRootsReducer", "aborted").increment(1L);
            return;
        }
        byte[] rowkey = Bytes.toBytes((String)key.toString());
        ArrayList entities = Lists.newArrayList();
        PersonMap personMap = new PersonMap();
        for (OafProtos.Oaf oaf : this.toOaf(values)) {
            switch (oaf.getKind()) {
                case entity: {
                    entities.add(oaf);
                    break;
                }
                case relation: {
                    this.handleRels(context, rowkey, oaf, personMap, true);
                    break;
                }
            }
        }
        OafProtos.Oaf.Builder builder = new OafEntityMerger(this.dedupConf).mergeEntities(key.toString(), entities);
        context.getCounter(this.dedupConf.getEntityName() + " root group size", this.lpad(entities.size())).increment(1L);
        this.emit(context, rowkey, this.dedupConf.getEntityName(), "body", builder.build().toByteArray(), "root");
        context.getCounter("hack", "personResult out").increment((long)personMap.size());
        for (OafProtos.Oaf oaf : personMap.values()) {
            this.handleRels(context, rowkey, oaf, personMap, false);
        }
        personMap.clear();
    }

    private Iterable<OafProtos.Oaf> toOaf(Iterable<ImmutableBytesWritable> values) {
        return Iterables.transform(values, (Function)new OafImporter());
    }

    private void handleRels(Reducer.Context context, byte[] rowkey, OafProtos.Oaf oaf, PersonMap personMap, boolean hack) throws IOException, InterruptedException, InvalidProtocolBufferException {
        byte[] revKey;
        OafDecoder decoder;
        if (hack && this.checkHack(new String(rowkey), this.dedupConf.getEntityName(), oaf, personMap)) {
            context.getCounter("hack", "personResult in").increment(1L);
        } else {
            decoder = this.rootToEntity(rowkey, oaf);
            this.emit(context, rowkey, decoder.relTypeName(), decoder.relTargetId(), decoder.toByteArray(), "[root -> entity]");
            decoder = this.entityToRoot(rowkey, oaf);
            revKey = Bytes.toBytes((String)decoder.relSourceId());
            this.emit(context, revKey, decoder.relTypeName(), new String(rowkey), decoder.toByteArray(), "[entity -> root]");
        }
        decoder = this.markDeleted(oaf, true);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit(context, revKey, decoder.relTypeName(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [dup -> entity]");
        decoder = this.markDeleted(oaf, false);
        revKey = Bytes.toBytes((String)decoder.relSourceId());
        this.emit(context, revKey, decoder.relTypeName(), decoder.relTargetId(), decoder.toByteArray(), "mark deleted [entity -> dup]");
    }

    private void emit(Reducer.Context context, byte[] rowkey, String family, String qualifier, byte[] value, String label) throws IOException, InterruptedException {
        Put put = new Put(rowkey).add(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), value);
        context.write((Object)new ImmutableBytesWritable(rowkey), (Object)put);
        context.getCounter(family, label).increment(1L);
    }

    public boolean checkHack(String root, String entityName, OafProtos.Oaf oaf, PersonMap personMap) {
        if (entityName.equals(TypeProtos.Type.result.toString()) && oaf.getRel().getRelType().toString().equals(RelTypeProtos.RelType.personResult.toString()) && this.md5matches(root, oaf.getRel().getSource())) {
            String id = oaf.getRel().getSource().replaceAll("^.*\\:\\:", "");
            personMap.put(id, oaf);
            return true;
        }
        return false;
    }

    private boolean md5matches(String id1, String id2) {
        return id1.replaceAll("^.*\\:\\:", "").equals(id2.replaceAll("^.*\\:\\:", ""));
    }

    private OafDecoder rootToEntity(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.rootToEntity);
    }

    private OafDecoder entityToRoot(byte[] rootRowkey, OafProtos.Oaf rel) {
        return this.patchRelations(rootRowkey, rel, OafPatch.entityToRoot);
    }

    private OafDecoder markDeleted(OafProtos.Oaf rel, boolean reverse) {
        return this.deleteRelations(rel, reverse);
    }

    private OafDecoder patchRelations(byte[] rootRowkey, OafProtos.Oaf rel, OafPatch patchKind) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false);
        switch (patchKind) {
            case rootToEntity: {
                builder.getDataInfoBuilder().setInferenceprovenance("dedup (BuildRoots p:rootToEntity)");
                builder.getRelBuilder().setSource(new String(rootRowkey));
                break;
            }
            case entityToRoot: {
                builder.getDataInfoBuilder().setInferenceprovenance("dedup (BuildRoots p:entityToRoot)");
                builder.getRelBuilder().setSource(builder.getRel().getTarget());
                builder.getRelBuilder().setTarget(new String(rootRowkey));
                break;
            }
        }
        return OafDecoder.decode(builder.build());
    }

    private OafDecoder deleteRelations(OafProtos.Oaf rel, boolean reverse) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)rel);
        builder.getDataInfoBuilder().setInferenceprovenance("dedup (BuildRoots d: " + reverse + ")");
        builder.getDataInfoBuilder().setDeletedbyinference(true);
        if (reverse) {
            String tmp = builder.getRel().getSource();
            builder.getRelBuilder().setSource(builder.getRel().getTarget());
            builder.getRelBuilder().setTarget(tmp);
        }
        return OafDecoder.decode(builder.build());
    }

    private String lpad(int s) {
        return StringUtils.leftPad((String)String.valueOf(s), (int)5);
    }

    class PersonMap
    extends HashMap<String, OafProtos.Oaf> {
        PersonMap() {
        }

        @Override
        public OafProtos.Oaf put(String key, OafProtos.Oaf value) {
            if (this.containsKey(key) && !DedupRootUtils.isRoot(value.getRel().getSource())) {
                return value;
            }
            return super.put(key, value);
        }
    }

    private static enum OafPatch {
        rootToEntity,
        entityToRoot;

    }
}

