/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Joiner;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfig;
import eu.dnetlib.data.mapreduce.hbase.dedup.config.DedupConfigLoader;
import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.pace.model.Person;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupPersonMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfigLoader.load(context.getConfiguration().get("dedup.wf.conf"));
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (DedupRootUtils.isRoot(new String(keyIn.copyBytes()))) {
            context.getCounter(this.dedupConf.getEntityName(), "roots skipped").increment(1L);
            return;
        }
        byte[] body = result.getValue(this.dedupConf.getEntityNameBytes(), Bytes.toBytes((String)"body"));
        if (body != null) {
            try {
                OafDecoder decoder = OafDecoder.decode(body);
                String hash = new Person(this.getPersonName(decoder)).hash();
                context.write((Object)new Text(hash), (Object)new ImmutableBytesWritable(body));
            }
            catch (Throwable e) {
                System.out.println("GOT EX " + e);
                e.printStackTrace(System.err);
                context.getCounter(this.dedupConf.getEntityName(), e.getClass().toString()).increment(1L);
            }
        } else {
            context.getCounter(this.dedupConf.getEntityName(), "missing body").increment(1L);
        }
    }

    private String getPersonName(OafDecoder decoder) {
        String fullname = decoder.getEntity().getPerson().getMetadata().getFullname();
        String firstname = decoder.getEntity().getPerson().getMetadata().getFirstname();
        String secondnames = Joiner.on((String)" ").join((Iterable)decoder.getEntity().getPerson().getMetadata().getSecondnamesList());
        return this.isValid(fullname) ? fullname : secondnames + ", " + firstname;
    }

    private boolean isValid(String fullname) {
        return fullname != null && !fullname.isEmpty();
    }
}

