/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class SolrServerPool {
    private List<HttpSolrServer> updateServerPool = Lists.newArrayList();
    private CloudSolrServer cloudServer;
    private final HashFunction hash = Hashing.murmur3_32();

    public SolrServerPool(String updateUrlLocal, String updateUrlList, String zkHost, String collection, boolean localFeeding) {
        for (URL url : this.parseUrlListPattern(updateUrlLocal, updateUrlList, localFeeding)) {
            this.updateServerPool.add(new HttpSolrServer(url + "/" + collection));
        }
        try {
            this.cloudServer = new CloudSolrServer(zkHost);
            this.cloudServer.setDefaultCollection(collection);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UpdateResponse add(SolrInputDocument doc) throws SolrServerException, IOException {
        return this.updateServerPool.get(this.hashPick(doc)).add(doc);
    }

    public UpdateResponse addAll(Iterator<SolrInputDocument> docs) throws SolrServerException, IOException {
        if (this.updateServerPool.size() == 1) {
            return this.updateServerPool.get(0).add(docs);
        }
        int i = Integer.parseInt(DnetXsltFunctions.randomInt((int)this.updateServerPool.size()));
        return this.updateServerPool.get(i).add(docs);
    }

    public UpdateResponse addAll(Collection<SolrInputDocument> docs) throws SolrServerException, IOException {
        if (this.updateServerPool.size() == 1) {
            return this.updateServerPool.get(0).add(docs);
        }
        int i = Integer.parseInt(DnetXsltFunctions.randomInt((int)this.updateServerPool.size()));
        return this.updateServerPool.get(i).add(docs);
    }

    public void deleteByQuery(String query) throws SolrServerException, IOException {
        this.cloudServer.deleteByQuery(query);
    }

    public void commitAll() throws SolrServerException, IOException {
        this.cloudServer.commit();
    }

    public void shutdownAll() throws SolrServerException {
        this.cloudServer.shutdown();
        for (SolrServer solrServer : this.updateServerPool) {
            solrServer.shutdown();
        }
    }

    private int hashPick(SolrInputDocument doc) {
        int hashCode = this.hash.hashBytes(doc.getFieldValue("__indexrecordidentifier").toString().getBytes()).asInt();
        return Math.abs(hashCode) % this.updateServerPool.size();
    }

    public List<URL> parseUrlListPattern(String local, String list, boolean localFeeding) {
        ArrayList res = Lists.newArrayList();
        try {
            if (localFeeding) {
                res.add(new URL(local));
            } else {
                Matcher matcher = Pattern.compile("(^.*)\\[(\\d+)\\.\\.(\\d+)\\](.*$)").matcher(list);
                if (matcher.matches()) {
                    String prefix = matcher.group(1);
                    int lb = Integer.parseInt(matcher.group(2));
                    int ub = Integer.parseInt(matcher.group(3));
                    String suffix = matcher.group(4);
                    for (int i = lb; i <= ub; ++i) {
                        res.add(new URL(prefix + i + suffix));
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("invalid url list: " + list, e);
        }
        System.out.println("parsed url(s): " + res);
        return res;
    }

    public List<URL> parseUrlList(String list) throws MalformedURLException {
        ArrayList res = Lists.newArrayList();
        for (String url : Splitter.on((String)",").trimResults().split((CharSequence)list)) {
            res.add(URI.create(url).toURL());
        }
        return res;
    }
}

