package eu.dnetlib.data.mapreduce.hbase.actions;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FilterList.Operator;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

abstract public class AbstractActionsJob extends AbstractHBaseMapReduceJob {

	@Override
	protected Job setJobDetails(Job job, Properties p) throws Exception {
		initMapper(job, getScan(p), p.getProperty(JobParams.HBASE_SOURCE_TABLE));

		job.setOutputFormatClass(TableOutputFormat.class);
		job.setMapOutputKeyClass(Text.class);
		job.setMapOutputValueClass(getMapOutputValueClass());
		job.setNumReduceTasks(0);

		return job;
	}

	private void initMapper(final Job job, final Scan scan, final String sourceTable) {
		try {
			TableMapReduceUtil.initTableMapperJob(sourceTable, scan, getMapperClass(), Text.class, ImmutableBytesWritable.class, job);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	abstract protected Class<? extends TableMapper<ImmutableBytesWritable, ?>> getMapperClass();

	abstract protected Class<?> getMapOutputValueClass();

	abstract protected void addSpecificFilters(FilterList filters);

	abstract protected void addSpecificScanClauses(Scan scan);

	private Scan getScan(Properties p) {

		Scan scan = new Scan();
		scan.setCaching(500);
		scan.setCacheBlocks(false);

		FilterList filters = new FilterList(Operator.MUST_PASS_ALL);

		//if (p.containsKey("set")) {
		//filters.addFilter(new FamilyFilter(CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes("set"))));
		//filters.addFilter(new QualifierFilter(CompareOp.EQUAL, new BinaryComparator(Bytes.toBytes(p.getProperty("set")))));
		//scan.addFamily(Bytes.toBytes("set"));
		//			byte[] qualifier = Bytes.toBytes(p.getProperty("set"));
		//			SingleColumnValueFilter filter = new SingleColumnValueFilter(Bytes.toBytes("set"), qualifier, CompareOp.EQUAL, qualifier);
		//			filter.setFilterIfMissing(true);
		//			filters.addFilter(filter);
		//scan.addColumn(Bytes.toBytes("set"), Bytes.toBytes(p.getProperty("set")));
		//}

		addSpecificFilters(filters);
		addSpecificScanClauses(scan);

		scan.setFilter(filters);
		return scan;
	}

}
