package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;

import eu.dnetlib.data.mapreduce.OptionalConfig;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class IndexConfig extends OptionalConfig {

	public static IndexConfig load(final String s) {
		return new IndexConfig(ConfigFactory.parseReader(new StringReader(s)));
	}

	public IndexConfig(final Config config) {
		super(config);
	}

	@SuppressWarnings("unchecked")
	public EntityConfigTable getConfigMap() {
		ConfigObject modelMap = getConfig().getObject("index.conf");
		Map<String, EntityConfig> map = Maps.transformValues(modelMap, new Function<ConfigValue, EntityConfig>() {

			@Override
			public EntityConfig apply(final ConfigValue value) {

				final HashMap<RelType, LinkDescriptor> links = Maps.newHashMap();
				for (Object o : (List<?>) ((Map<String, ?>) value.unwrapped()).get("links")) {
					final Map<String, ?> map = (Map<String, ?>) o;

					final RelType relType = RelType.valueOf((String) map.get("relType"));
					final Set<String> fields = Sets.newHashSet((List<String>) map.get("fields"));
					final Type target = Type.valueOf((String) map.get("targetEntity"));
					final Boolean isChild = ((String) map.get("expandAs")).equals("child");

					links.put(relType, new LinkDescriptor(relType, target, isChild, fields));
				}
				return new EntityConfig((Boolean) ((Map<String, ?>) value.unwrapped()).get("dups"), links);
			}
		});

		final EntityConfigTable res = new EntityConfigTable();
		for (String key : map.keySet()) {
			res.put(Type.valueOf(key), map.get(key));
		}
		return res;
	}

	@Deprecated
	@SuppressWarnings("unchecked")
	public EntityLinkTable getLinkMap() {
		ConfigObject modelMap = getConfig().getObject("index.conf");
		Map<String, HashMap<RelType, LinkDescriptor>> map = Maps.transformValues(modelMap, new Function<ConfigValue, HashMap<RelType, LinkDescriptor>>() {

			@Override
			public HashMap<RelType, LinkDescriptor> apply(final ConfigValue value) {
				final HashMap<RelType, LinkDescriptor> links = Maps.newHashMap();
				for (Object o : (List<?>) ((Map<String, ?>) value.unwrapped()).get("links")) {
					final Map<String, ?> map = (Map<String, ?>) o;

					final RelType relType = RelType.valueOf((String) map.get("relType"));
					final Set<String> fields = Sets.newHashSet((List<String>) map.get("fields"));
					final Type target = Type.valueOf((String) map.get("targetEntity"));
					final Boolean isChild = ((String) map.get("expandAs")).equals("child");

					links.put(relType, new LinkDescriptor(relType, target, isChild, fields));
				}
				return links;
			}
		});

		final EntityLinkTable res = new EntityLinkTable();
		for (String key : map.keySet()) {
			res.put(Type.valueOf(key), map.get(key));
		}
		return res;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
