package eu.dnetlib.data.mapreduce.util;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;

import com.google.common.base.Function;
import com.google.protobuf.InvalidProtocolBufferException;

import eu.dnetlib.data.proto.OafProtos.Oaf;

public class OafImporter implements Function<ImmutableBytesWritable, Oaf> {
	@Override
	public Oaf apply(ImmutableBytesWritable input) {
		try {
			return Oaf.parseFrom(input.copyBytes());
		} catch (InvalidProtocolBufferException e) {
			System.err.println("unable to parse oaf: " + e.getMessage());
			return null;
		}
	}
}
