/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.actions2;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class GarbageActionsMapper
extends TableMapper<ImmutableBytesWritable, Delete> {
    private static final String LATEST_RAW_SETS = "latestRawSets";
    private Set<byte[]> latestRawSets = Sets.newHashSet();
    private long dateLimit;
    private final long MAX_DATE_INTERVAL = 345600000L;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dateLimit = DateUtils.now() - 345600000L;
        String s = context.getConfiguration().get(LATEST_RAW_SETS);
        if (s != null) {
            for (String set : Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)s))) {
                this.latestRawSets.add(Bytes.toBytes((String)set));
            }
        }
        if (this.latestRawSets.isEmpty()) {
            throw new IOException("Input parameter (latestRawSets) is missing or empty: " + s);
        }
    }

    protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
        if (this.isInARecentRawSet(value)) {
            return;
        }
        context.getCounter("Actions", "N. Deletes").increment(1L);
        context.write((Object)key, (Object)new Delete(key.copyBytes()));
    }

    private boolean isInARecentRawSet(Result value) {
        for (byte[] s1 : value.getFamilyMap(Bytes.toBytes((String)"set")).keySet()) {
            if (!this.isRecentRawSet(s1)) continue;
            return true;
        }
        return false;
    }

    private boolean isRecentRawSet(byte[] rawSet) {
        String date = (String)Iterables.getLast((Iterable)Splitter.on((String)"_").split((CharSequence)Bytes.toString((byte[])rawSet)));
        if (Long.parseLong(date) > this.dateLimit) {
            return true;
        }
        for (byte[] s : this.latestRawSets) {
            if (!Bytes.equals((byte[])rawSet, (byte[])s)) continue;
            return true;
        }
        return false;
    }
}

