/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.pace.model.Person;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupPersonMapper
extends TableMapper<Text, ImmutableBytesWritable> {
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfigLoader.load((String)context.getConfiguration().get("dedup.wf.conf"));
    }

    protected void map(ImmutableBytesWritable keyIn, Result result, Mapper.Context context) throws IOException, InterruptedException {
        if (DedupRootUtils.isRoot(new String(keyIn.copyBytes()))) {
            context.getCounter(this.dedupConf.getEntityName(), "roots skipped").increment(1L);
            return;
        }
        byte[] body = result.getValue(this.dedupConf.getEntityNameBytes(), Bytes.toBytes((String)"body"));
        if (body != null) {
            try {
                OafDecoder decoder = OafDecoder.decode((byte[])body);
                String hash = new Person(decoder.getEntity().getPerson().getMetadata().getFullname(), false).hash();
                context.write((Object)new Text(hash), (Object)new ImmutableBytesWritable(body));
            }
            catch (Throwable e) {
                System.out.println("GOT EX " + e);
                e.printStackTrace(System.err);
                context.getCounter(this.dedupConf.getEntityName(), e.getClass().toString()).increment(1L);
            }
        } else {
            context.getCounter(this.dedupConf.getEntityName(), "missing body").increment(1L);
        }
    }
}

