/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.collect.Lists;
import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.OafEntityMerger;
import eu.dnetlib.data.proto.OafProtos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class UpdateMerger {
    private static final String UPDATE_MERGER = "UPDATE_MERGE";
    private static final String N_MERGES = "N_MERGES";

    public static OafProtos.Oaf mergeBodyUpdates(Mapper.Context context, Map<byte[], byte[]> map) throws InvalidProtocolBufferException {
        byte[] value = map.get(Bytes.toBytes((String)"body"));
        if (value == null) {
            return null;
        }
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder((OafProtos.Oaf)OafProtos.Oaf.parseFrom((byte[])value));
        ArrayList keys = Lists.newArrayList();
        for (byte[] o : map.keySet()) {
            String sKey = Bytes.toString((byte[])o);
            if (!sKey.startsWith("update_")) continue;
            keys.add(sKey);
        }
        Collections.sort(keys);
        for (String k : keys) {
            OafProtos.Oaf update = OafProtos.Oaf.parseFrom((byte[])map.get(Bytes.toBytes((String)k)));
            builder = builder.mergeFrom(update);
        }
        new OafEntityMerger().doMergeEntities(builder);
        if (!keys.isEmpty()) {
            context.getCounter(UPDATE_MERGER, N_MERGES).increment((long)keys.size());
        }
        return builder.build();
    }
}

