package eu.dnetlib.data.mapreduce.hbase.dataimport;

import java.util.Properties;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

public class HFileImportJob extends AbstractHBaseMapReduceJob {

	@Override
	protected Job setJobDetails(Job job, Properties p) throws Exception {
		job.setMapOutputKeyClass(ImmutableBytesWritable.class);
		job.setMapOutputValueClass(Put.class);
		//job.setMapOutputValueClass(KeyValue.class);
		job.setMapperClass(ImportRecordsMapper.class);

		job.setInputFormatClass(SequenceFileInputFormat.class);
		job.setOutputFormatClass(HFileOutputFormat.class);

		job.setPartitionerClass(TotalOrderPartitioner.class);

		SequenceFileInputFormat.setInputPaths(job, p.getProperty(JobParams.MAPRED_INPUT_DIR));

		HFileOutputFormat.setOutputPath(job, new Path(p.getProperty(JobParams.MAPRED_OUTPUT_DIR)));
		HFileOutputFormat.setCompressOutput(job, true);

		final Configuration conf = HBaseConfiguration.create(job.getConfiguration());
		final String tableName = p.getProperty(JobParams.HBASE_TARGET_TABLE);

		HFileOutputFormat.configureIncrementalLoad(job, new HTable(conf, tableName));

		return job;
	}

}
