/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.proto.RelTypeProtos;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupGrouperMapper
extends TableMapper<Text, Put> {
    private static final boolean WRITE_TO_WAL = false;
    public static final String COUNTER_GROUP = "dedup.grouper";
    public static final String COUNTER_NAME = "written.rels";

    protected void map(ImmutableBytesWritable keyIn, Result value, Mapper.Context context) throws IOException, InterruptedException {
        List kvList = value.list();
        System.out.println("Grouper mapping " + kvList.size() + " rels for key: " + new String(keyIn.copyBytes()));
        for (KeyValue n : kvList) {
            for (KeyValue j : kvList) {
                byte[] jq;
                byte[] nq = n.getQualifier();
                if (Arrays.equals(nq, jq = j.getQualifier())) continue;
                Put put = new Put(nq).add(Bytes.toBytes((String)RelTypeProtos.RelType.similarRel.toString()), jq, Bytes.toBytes((String)""));
                put.setWriteToWAL(false);
                context.write((Object)new Text(nq), (Object)put);
                context.getCounter(COUNTER_GROUP, COUNTER_NAME).increment(1L);
            }
        }
    }
}

