/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.index.config;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import eu.dnetlib.data.mapreduce.OptionalConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfig;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityConfigTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.EntityLinkTable;
import eu.dnetlib.data.mapreduce.hbase.index.config.LinkDescriptor;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class IndexConfig
extends OptionalConfig {
    public static IndexConfig load(String s) {
        return new IndexConfig(ConfigFactory.parseReader((Reader)new StringReader(s)));
    }

    public IndexConfig(Config config) {
        super(config);
    }

    public EntityConfigTable getConfigMap() {
        ConfigObject modelMap = this.getConfig().getObject("index.conf");
        Map map = Maps.transformValues((Map)modelMap, (Function)new Function<ConfigValue, EntityConfig>(){

            public EntityConfig apply(ConfigValue value) {
                HashMap links = Maps.newHashMap();
                for (Object o : (List)((Map)value.unwrapped()).get("links")) {
                    Map map = (Map)o;
                    RelTypeProtos.RelType relType = RelTypeProtos.RelType.valueOf((String)((String)map.get("relType")));
                    HashSet fields = Sets.newHashSet((Iterable)((List)map.get("fields")));
                    TypeProtos.Type target = TypeProtos.Type.valueOf((String)((String)map.get("targetEntity")));
                    Boolean isChild = ((String)map.get("expandAs")).equals("child");
                    links.put(relType, new LinkDescriptor(relType, target, isChild, fields));
                }
                return new EntityConfig((Boolean)((Map)value.unwrapped()).get("dups"), links);
            }
        });
        EntityConfigTable res = new EntityConfigTable();
        for (String key : map.keySet()) {
            res.put(TypeProtos.Type.valueOf((String)key), map.get(key));
        }
        return res;
    }

    @Deprecated
    public EntityLinkTable getLinkMap() {
        ConfigObject modelMap = this.getConfig().getObject("index.conf");
        Map map = Maps.transformValues((Map)modelMap, (Function)new Function<ConfigValue, HashMap<RelTypeProtos.RelType, LinkDescriptor>>(){

            public HashMap<RelTypeProtos.RelType, LinkDescriptor> apply(ConfigValue value) {
                HashMap links = Maps.newHashMap();
                for (Object o : (List)((Map)value.unwrapped()).get("links")) {
                    Map map = (Map)o;
                    RelTypeProtos.RelType relType = RelTypeProtos.RelType.valueOf((String)((String)map.get("relType")));
                    HashSet fields = Sets.newHashSet((Iterable)((List)map.get("fields")));
                    TypeProtos.Type target = TypeProtos.Type.valueOf((String)((String)map.get("targetEntity")));
                    Boolean isChild = ((String)map.get("expandAs")).equals("child");
                    links.put(relType, new LinkDescriptor(relType, target, isChild, fields));
                }
                return links;
            }
        });
        EntityLinkTable res = new EntityLinkTable();
        for (String key : map.keySet()) {
            res.put(TypeProtos.Type.valueOf((String)key), map.get(key));
        }
        return res;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

