package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.Set;

import com.google.gson.Gson;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class LinkDescriptor {

	private RelType relType;
	private Type target;
	private boolean isChild = false;
	private Set<String> fields;

	public LinkDescriptor(RelType relType, Type target, boolean isChild, Set<String> fields) {
		super();
		this.setRelType(relType);
		this.setTarget(target);
		this.setChild(isChild);
		this.setFields(fields);
	}

	public LinkDescriptor(RelType relType, Type target) {
		super();
		this.setRelType(relType);
		this.setTarget(target);
	}

	public RelType getRelType() {
		return relType;
	}

	public Type getTarget() {
		return target;
	}

	public boolean isChild() {
		return isChild;
	}

	public void setRelType(RelType relType) {
		this.relType = relType;
	}

	public void setTarget(Type target) {
		this.target = target;
	}

	public void setChild(boolean isChild) {
		this.isChild = isChild;
	}

	public Set<String> getFields() {
		return fields;
	}

	public void setFields(Set<String> fields) {
		this.fields = fields;
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

}
