/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dataimport;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dataimport.ImportRecordsMapper;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;

public class HFileImportJob
extends AbstractHBaseMapReduceJob {
    @Override
    protected Job setJobDetails(Job job, Properties p) throws Exception {
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(Put.class);
        job.setMapperClass(ImportRecordsMapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        SequenceFileInputFormat.setInputPaths((Job)job, (String)p.getProperty("mapred.input.dir"));
        HFileOutputFormat.setOutputPath((Job)job, (Path)new Path(p.getProperty("mapred.output.dir")));
        HFileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        Configuration conf = HBaseConfiguration.create((Configuration)job.getConfiguration());
        String tableName = p.getProperty("hbase.mapred.outputtable");
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)new HTable(conf, tableName));
        return job;
    }
}

