/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.protobuf.InvalidProtocolBufferException;
import eu.dnetlib.data.mapreduce.util.DedupRootUtils;
import eu.dnetlib.data.proto.DedupRelProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.RelTypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetOafXsltFunctions;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;

public class DedupFindRootsMapper
extends TableMapper<ImmutableBytesWritable, Put> {
    private static final boolean WRITE_TO_WAL = false;
    private DedupConfig dedupConf;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.dedupConf = DedupConfigLoader.load((String)context.getConfiguration().get("dedup.wf.conf"));
        System.out.println("dedup findRoots mapper\nwf conf: " + this.dedupConf.toString());
    }

    protected void map(ImmutableBytesWritable rowkey, Result value, Mapper.Context context) throws IOException, InterruptedException {
        NavigableMap similarRels = value.getFamilyMap(Bytes.toBytes((String)RelTypeProtos.RelType.similarRel.toString()));
        if (similarRels != null && !similarRels.isEmpty()) {
            ByteBuffer min = this.findMin(ByteBuffer.wrap(rowkey.get()), similarRels.keySet());
            byte[] row = rowkey.copyBytes();
            byte[] root = DedupRootUtils.newIdBytes(min, this.dedupConf.getDedupRun());
            System.out.println("Found root: " + new String(root));
            this.emitDedupRel(context, "dedupRel", row, root, this.buildRel(row, root));
            this.emitDedupRel(context, "dedupRel", root, row, this.buildRel(root, row));
            context.getCounter("DedupFindRootsMapper", "dedupRel (x2)").increment(1L);
            this.emitBody(context, row, value.getValue(Bytes.toBytes((String)this.dedupConf.getEntityName()), Bytes.toBytes((String)"body")));
        } else {
            context.getCounter("DedupFindRootsMapper", "row not in similarity mesh").increment(1L);
        }
    }

    private ByteBuffer findMin(ByteBuffer min, Iterable<byte[]> keys) {
        for (byte[] q : keys) {
            ByteBuffer iq = ByteBuffer.wrap(q);
            if (min.compareTo(iq) <= 0) continue;
            min = iq;
        }
        return min;
    }

    private void emitBody(Mapper.Context context, byte[] row, byte[] body) throws InvalidProtocolBufferException, IOException, InterruptedException {
        if (body == null) {
            context.getCounter(this.dedupConf.getEntityName(), "missing body").increment(1L);
            System.err.println("missing body: " + new String(row));
            return;
        }
        OafProtos.Oaf prototype = OafProtos.Oaf.parseFrom((byte[])body);
        if (prototype.getDataInfo().getDeletedbyinference()) {
            context.getCounter("DedupFindRootsMapper", "bodies already deleted").increment(1L);
        } else {
            OafProtos.Oaf.Builder oafRoot = OafProtos.Oaf.newBuilder((OafProtos.Oaf)prototype);
            oafRoot.getDataInfoBuilder().setDeletedbyinference(true).setInferred(true).setInferenceprovenance("dedup");
            byte[] family = Bytes.toBytes((String)this.dedupConf.getEntityName());
            byte[] qualifier = Bytes.toBytes((String)"body");
            Put put = new Put(row).add(family, qualifier, oafRoot.build().toByteArray());
            put.setWriteToWAL(false);
            context.write((Object)new ImmutableBytesWritable(row), (Object)put);
            context.getCounter("DedupFindRootsMapper", "bodies marked deleted").increment(1L);
        }
    }

    private byte[] buildRel(byte[] from, byte[] to) {
        OafProtos.OafRel.Builder oafRel = OafProtos.OafRel.newBuilder().setRelType(RelTypeProtos.RelType.dedupRel).setDedupRel(DedupRelProtos.DedupRel.newBuilder()).setChild(false).setSource(new String(from)).setTarget(new String(to));
        OafProtos.Oaf oaf = OafProtos.Oaf.newBuilder().setKind(KindProtos.Kind.relation).setTimestamp(System.currentTimeMillis()).setDataInfo(AbstractDNetOafXsltFunctions.getDataInfo(null, (String)"0.8", (boolean)false, (boolean)true).setInferenceprovenance("dedup")).setRel(oafRel).build();
        return oaf.toByteArray();
    }

    private void emitDedupRel(Mapper.Context context, String relName, byte[] from, byte[] to, byte[] value) throws IOException, InterruptedException {
        Put put = new Put(from).add(Bytes.toBytes((String)relName), to, value);
        context.write((Object)new ImmutableBytesWritable(from), (Object)put);
    }
}

