/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupPersonBean;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.model.PersonComparatorUtils;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class FindDedupCandidatePersonsMapper
extends TableMapper<Text, Text> {
    private static final byte[] PERSON_CF = TypeProtos.Type.person.toString().getBytes();
    private static final byte[] PERSON_COL = "body".getBytes();
    private static final byte[] PERSONRESULT_CF = "personResult".getBytes();

    protected void setup(Mapper.Context context) {
    }

    protected void map(ImmutableBytesWritable rowkey, Result row, Mapper.Context context) throws IOException, InterruptedException {
        String id = Bytes.toString((byte[])rowkey.get());
        String fullname = this.extractFullname(row);
        Set<String> resultIds = this.extractResultIds(row);
        if (fullname != null) {
            Text text = new DedupPersonBean(id, fullname, resultIds).toText();
            for (String k : PersonComparatorUtils.getNgramsForPerson((String)fullname)) {
                context.write((Object)new Text(k), (Object)text);
            }
        }
    }

    private Set<String> extractResultIds(Result row) {
        return Sets.newHashSet((Iterable)Iterables.transform(row.getFamilyMap(PERSONRESULT_CF).keySet(), (Function)new Function<byte[], String>(){

            public String apply(byte[] b) {
                return Bytes.toString((byte[])b);
            }
        }));
    }

    private String extractFullname(Result row) {
        byte[] body = row.getValue(PERSON_CF, PERSON_COL);
        if (body == null) {
            return null;
        }
        return OafDecoder.decode((byte[])body).getEntity().getPerson().getMetadata().getFullname();
    }
}

