/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import eu.dnetlib.data.mapreduce.util.TemplateResources;
import eu.dnetlib.data.mapreduce.util.XmlRecordFactory;
import eu.dnetlib.data.proto.TypeProtos;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class TemplateFactory {
    private static final Log log = LogFactory.getLog(TemplateFactory.class);
    protected TemplateResources resources = new TemplateResources();

    public String buildBody(TypeProtos.Type type, List<String> metadata, List<String> rels, List<String> children) {
        StringTemplate body = this.getTemplate(this.resources.getEntity());
        body.setAttribute("name", (Object)type.toString());
        body.setAttribute("metadata", metadata);
        body.setAttribute("rels", rels);
        body.setAttribute("children", children);
        return body.toString();
    }

    public String getChild(String name, String id, List<String> metadata) {
        StringTemplate child = this.getTemplate(this.resources.getChild());
        child.setAttribute("name", (Object)name);
        child.setAttribute("hasId", (Object)(id != null ? 1 : 0));
        child.setAttribute("id", (Object)(id != null ? XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(id)) : ""));
        child.setAttribute("metadata", metadata);
        String string = child.toString();
        return string;
    }

    public String buildRecord(TypeProtos.Type type, String objIdentifier, String dateOfCollection, String schemaLocation, String body) {
        StringTemplate recordTemplate = this.getTemplate(this.resources.getRecord());
        recordTemplate.setAttribute("id", (Object)XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(objIdentifier)));
        recordTemplate.setAttribute("dateofcollection", (Object)dateOfCollection);
        recordTemplate.setAttribute("schemaLocation", (Object)schemaLocation);
        recordTemplate.setAttribute("it", (Object)body);
        return recordTemplate.toString();
    }

    public String getRel(TypeProtos.Type type, String objIdentifier, List<String> fields, String semanticclass, String semantischeme, boolean inferred, String trust, String inferenceprovenance, String provenanceaction) {
        StringTemplate template = this.getTemplate(this.resources.getRel());
        template.setAttribute("type", (Object)type.toString());
        template.setAttribute("objIdentifier", (Object)XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(objIdentifier)));
        template.setAttribute("class", (Object)semanticclass);
        template.setAttribute("scheme", (Object)semantischeme);
        template.setAttribute("metadata", fields);
        template.setAttribute("inferred", (Object)inferred);
        template.setAttribute("trust", (Object)trust);
        template.setAttribute("inferenceprovenance", (Object)inferenceprovenance);
        template.setAttribute("provenanceaction", (Object)provenanceaction);
        return template.toString();
    }

    public String getInstance(String resultId, List<String> instancemetadata, List<String> webresources) {
        StringTemplate template = this.getTemplate(this.resources.getInstance());
        template.setAttribute("instanceId", (Object)XmlRecordFactory.escapeXml(XmlRecordFactory.removePrefix(resultId)));
        template.setAttribute("metadata", instancemetadata);
        template.setAttribute("webresources", webresources);
        return template.toString();
    }

    public String getWebResource(String identifier) {
        StringTemplate template = this.getTemplate(this.resources.getWebresource());
        template.setAttribute("identifier", (Object)XmlRecordFactory.escapeXml(identifier));
        return template.toString();
    }

    private StringTemplate getTemplate(Resource res) {
        StringWriter body = new StringWriter();
        try {
            IOUtils.copy((InputStream)res.getInputStream(), (Writer)body);
            String string = body.toString();
            return new StringTemplate(string);
        }
        catch (IOException e) {
            log.error((Object)"unable to get template", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

