package eu.dnetlib.data.mapreduce.hbase.dataexport;

import java.util.Properties;

import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.mapreduce.Job;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;

/**
 * HBaseCopyTableJob is a simple wrapper over org.apache.hadoop.hbase.mapreduce.CopyTable that makes it invokable from a
 * D-Net workflow, passing the required parameters.
 * 
 * Copies the given table to the remote hbase instance.
 * 
 * @author claudio
 * 
 */
public class HBaseCopyTableJob extends AbstractHBaseMapReduceJob {

	@Override
	protected Job setJobDetails(Job job, Properties p) throws Exception {

		String remoteCluster = "--peer.adr=" + p.getProperty("peername");
		String tablename = p.getProperty("tablename");

		String[] args = Iterables.toArray(Lists.newArrayList(remoteCluster, tablename), String.class);

		return CopyTable.createSubmittableJob(job.getConfiguration(), args);
	}

}
