package eu.dnetlib.data.mapreduce.hbase.dedup;

import java.io.IOException;
import java.util.Properties;

import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

import eu.dnetlib.data.mapreduce.JobParams;
import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;

public class DedupBuildRootsJob extends AbstractHBaseMapReduceJob {

	@Override
	public Job setJobDetails(Job job, Properties p) {

		initMapper(job, getScan(p), p.getProperty(JobParams.HBASE_SOURCE_TABLE));

		job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
		job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);

		job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
		job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);

		job.setNumReduceTasks(500);

		return job;
	}

	private Scan getScan(Properties p) {
		Scan scan = new Scan();
		scan.setCaching(100); // 1 is the default in Scan, which will be bad for MapReduce jobs

		scan.setCacheBlocks(false); // don't set to true for MR jobs

		DedupConfig dedupConfig = DedupConfigLoader.load(p.getProperty("dedup.wf.conf"));

		scan.setFilter(new PrefixFilter(Bytes.toBytes(dedupConfig.getEntityId())));

		return scan;
	}

	private void initMapper(final Job job, final Scan scan, final String sourceTable) {
		try {
			TableMapReduceUtil.initTableMapperJob(sourceTable, scan, DedupBuildRootsMapper.class, Text.class, ImmutableBytesWritable.class, job);
			TableMapReduceUtil.initTableReducerJob(sourceTable, DedupBuildRootsReducer.class, job);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
