package eu.dnetlib.data.mapreduce.hbase.index.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.TypeProtos.Type;

public class EntityConfigTable extends HashMap<Type, EntityConfig> {

	private static final long serialVersionUID = 6087987206844928698L;

	public Collection<LinkDescriptor> getDescriptors(final Type source) {
		return super.get(source).getLinks().values();
	}

	public LinkDescriptor getDescriptor(final Type type, final RelType relType) {
		return super.get(type).getLinks().get(relType);
	}

	public Set<String> getFilter(final Type type, final RelType relType) {
		final LinkDescriptor ld = getDescriptor(type, relType);
		return ld != null ? ld.getFields() : new HashSet<String>();
	}

	public boolean includeDuplicates(final Type type) {
		return super.get(type).getIndexDuplicates();
	}

}
