/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.hbase.dedup;

import eu.dnetlib.data.mapreduce.hbase.AbstractHBaseMapReduceJob;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupBuildRootsMapper;
import eu.dnetlib.data.mapreduce.hbase.dedup.DedupBuildRootsReducer;
import eu.dnetlib.pace.util.DedupConfig;
import eu.dnetlib.pace.util.DedupConfigLoader;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;

public class DedupBuildRootsJob
extends AbstractHBaseMapReduceJob {
    @Override
    public Job setJobDetails(Job job, Properties p) {
        this.initMapper(job, this.getScan(p), p.getProperty("hbase.source.table"));
        job.getConfiguration().setBoolean("mapred.reduce.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
        job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
        job.getConfiguration().setBoolean("mapreduce.reduce.speculative", false);
        job.setNumReduceTasks(500);
        return job;
    }

    private Scan getScan(Properties p) {
        Scan scan = new Scan();
        scan.setCaching(100);
        scan.setCacheBlocks(false);
        DedupConfig dedupConfig = DedupConfigLoader.load((String)p.getProperty("dedup.wf.conf"));
        scan.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)dedupConfig.getEntityId())));
        return scan;
    }

    private void initMapper(Job job, Scan scan, String sourceTable) {
        try {
            TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, DedupBuildRootsMapper.class, Text.class, ImmutableBytesWritable.class, (Job)job);
            TableMapReduceUtil.initTableReducerJob((String)sourceTable, DedupBuildRootsReducer.class, (Job)job);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

