/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mapreduce.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.mapreduce.hbase.dedup.TrustOrdering;
import eu.dnetlib.data.proto.KeyValueProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.SpecialTrustProtos;
import eu.dnetlib.data.proto.StructuredPropertyProtos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class OafEntityMerger {
    private final Predicate<StructuredPropertyProtos.StructuredProperty> filterMainTitles = new Predicate<StructuredPropertyProtos.StructuredProperty>(){

        public boolean apply(StructuredPropertyProtos.StructuredProperty sp) {
            return sp.getQualifier() != null && sp.getQualifier().getClassname().equals("main title");
        }
    };
    private final Predicate<String> skipEmpty = new Predicate<String>(){

        public boolean apply(String s) {
            return s != null && !s.isEmpty();
        }
    };

    public OafProtos.Oaf.Builder mergeEntities(String id, Iterable<OafProtos.Oaf> entities) {
        OafProtos.Oaf.Builder builder = OafProtos.Oaf.newBuilder();
        String trust = "0.0";
        for (OafProtos.Oaf oaf : new TrustOrdering().immutableSortedCopy(entities)) {
            if (!oaf.getKind().equals((Object)KindProtos.Kind.entity)) {
                throw new IllegalArgumentException("expected OafEntity!");
            }
            String currentTrust = oaf.getDataInfo().getTrust();
            if (!currentTrust.equals(SpecialTrustProtos.SpecialTrust.NEUTRAL.toString())) {
                trust = currentTrust;
            }
            builder.mergeFrom(oaf);
        }
        this.doMergeEntities(builder);
        builder.getEntityBuilder().setId(id);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false).setTrust(trust);
        return builder;
    }

    public void doMergeEntities(OafProtos.Oaf.Builder builder) {
        switch (builder.getEntity().getType()) {
            case datasource: {
                break;
            }
            case organization: {
                break;
            }
            case person: {
                PersonProtos.Person.Metadata.Builder person = builder.getEntityBuilder().getPersonBuilder().getMetadataBuilder();
                for (String field : Lists.newArrayList((Object[])new String[]{"secondnames"})) {
                    this.setSingleString((Message.Builder)person, field);
                }
                break;
            }
            case project: {
                break;
            }
            case result: {
                ResultProtos.Result.Metadata.Builder result = builder.getEntityBuilder().getResultBuilder().getMetadataBuilder();
                this.setTitle(result);
                for (String field : Lists.newArrayList((Object[])new String[]{"subject", "relevantdate"})) {
                    this.setStructuredProperty((Message.Builder)result, field);
                }
                for (String field : Lists.newArrayList((Object[])new String[]{"description"})) {
                    this.setSingleString((Message.Builder)result, field);
                }
                for (String field : Lists.newArrayList((Object[])new String[]{"collectedfrom"})) {
                    this.setKeyValues((Message.Builder)builder.getEntityBuilder(), field);
                }
                for (String field : Lists.newArrayList((Object[])new String[]{"pid"})) {
                    this.setStructuredProperty((Message.Builder)builder.getEntityBuilder(), field);
                }
                for (String field : Lists.newArrayList((Object[])new String[]{"originalId"})) {
                    this.setStrings((Message.Builder)builder.getEntityBuilder(), field);
                }
                break;
            }
        }
    }

    private void setStructuredProperty(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List sps = (List)builder.getField(fd);
        if (sps != null && !sps.isEmpty()) {
            for (StructuredPropertyProtos.StructuredProperty sp : sps) {
                map.put(sp.getValue(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setKeyValues(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List kvs = (List)builder.getField(fd);
        if (kvs != null && !kvs.isEmpty()) {
            for (KeyValueProtos.KeyValue sp : kvs) {
                map.put(sp.getKey(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setSingleString(Message.Builder builder, String fieldName) {
        String s;
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty() && (s = (String)Iterables.getLast((Iterable)Iterables.filter((Iterable)field, this.skipEmpty), (Object)"")) != null && !s.isEmpty()) {
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new String[]{s}));
        }
    }

    private void setStrings(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashSet set = Sets.newHashSet();
        if (field != null && !field.isEmpty()) {
            for (String s : Iterables.filter((Iterable)field, this.skipEmpty)) {
                set.add(s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Iterable)set));
        }
    }

    private void setTitle(ResultProtos.Result.Metadata.Builder metadata) {
        Iterable filtered = Iterables.filter((Iterable)metadata.getTitleList(), this.filterMainTitles);
        if (!Iterables.isEmpty((Iterable)filtered)) {
            metadata.clearTitle().addTitle((StructuredPropertyProtos.StructuredProperty)Iterables.getLast((Iterable)filtered));
        }
    }
}

