package eu.dnetlib.functionality.modular.ui.vocabularies.adapters;

import com.google.common.base.Function;

import eu.dnetlib.functionality.modular.ui.vocabularies.controllers.VocabulariesController;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Vocabulary;

/**
 * This class is used in {@link VocabulariesController} when un-marshaling of a {@link Vocabulary} object is needed.
 * 
 * @author Andrea Mannocci
 * 
 */
public class VocabularyAdapter implements Function<String, Vocabulary> {

	@Override
	public Vocabulary apply(final String s) {
		String[] tokens = s.split("§§§");
		return new Vocabulary(tokens[0].trim(), tokens[1].trim(), tokens[2].trim(), tokens[3].trim());
	}

}
