/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.vocabularies.controllers;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.functionality.modular.ui.vocabularies.adapters.SynonymAdapter;
import eu.dnetlib.functionality.modular.ui.vocabularies.adapters.TermAdapter;
import eu.dnetlib.functionality.modular.ui.vocabularies.adapters.VocabularyAdapter;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Synonym;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Vocabulary;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VocabulariesController {
    private static final Log log = LogFactory.getLog(VocabulariesController.class);
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    @Resource(name="registryLocator")
    private ServiceLocator<ISRegistryService> registryLocator;

    @RequestMapping(value={"/ui/vocabularies.json"})
    public void getVocabularies(HttpServletResponse response) throws ISLookUpException, IOException {
        log.info((Object)"vocabularies.json");
        String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') order by $x//VOCABULARY_NAME return concat ($x//RESOURCE_IDENTIFIER/@value,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_DESCRIPTION,' \u00a7\u00a7\u00a7 ',$x//VOCABULARY_NAME/@code)";
        List vocabularies = Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(query), (Function)new VocabularyAdapter());
        HashMap<String, Vocabulary> map = new HashMap<String, Vocabulary>();
        for (Vocabulary voc : vocabularies) {
            map.put(voc.getId(), voc);
        }
        IOUtils.copy((Reader)new StringReader(new Gson().toJson(map)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/terms.json"})
    public void getTerms(HttpServletResponse response, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws ISLookUpException, IOException {
        log.info((Object)("terms.json?vocabularyId=" + vocabularyId));
        String queryTerms = "for $x in /*[.//RESOURCE_IDENTIFIER/@value=\"{vocabularyId}\"]//TERM order by $x/@english_name return concat ($x/@english_name,' \u00a7\u00a7\u00a7 ',$x/@native_name,' \u00a7\u00a7\u00a7 ',$x/@encoding,' \u00a7\u00a7\u00a7 ',$x/@code)";
        queryTerms = queryTerms.replace("{vocabularyId}", vocabularyId);
        ArrayList terms = Lists.newArrayList((Iterable)Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(queryTerms), (Function)new TermAdapter()));
        for (Term term : terms) {
            String querySynonyms = "for $x in /*[.//RESOURCE_IDENTIFIER/@value=\"{vocabularyId}\"]//TERM[@english_name=\"{term}\"]//SYNONYM order by $x/@term return concat ($x/@term,' \u00a7\u00a7\u00a7 ',$x/@encoding)";
            querySynonyms = querySynonyms.replace("{vocabularyId}", vocabularyId).replace("{term}", term.getEnglishName()).replace("&", "&amp;");
            List synonyms = Lists.transform((List)((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(querySynonyms), (Function)new SynonymAdapter());
            term.getSynonyms().addAll(synonyms);
        }
        IOUtils.copy((Reader)new StringReader(new Gson().toJson((Object)terms)), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/commitVocabulary"}, method={RequestMethod.POST})
    public void commitTerms(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws IOException, ISRegistryException, JAXBException {
        log.info((Object)("committing vocabulary id = " + vocabularyId));
        Type collectionType = new TypeToken<ArrayList<Term>>(){}.getType();
        ArrayList terms = (ArrayList)new Gson().fromJson((Reader)request.getReader(), collectionType);
        for (Term t : terms) {
            t.setCode(StringEscapeUtils.escapeXml((String)t.getCode()));
            t.setEncoding(StringEscapeUtils.escapeXml((String)t.getEncoding()));
            t.setEnglishName(StringEscapeUtils.escapeXml((String)t.getEnglishName()));
            t.setNativeName(StringEscapeUtils.escapeXml((String)t.getNativeName()));
            for (Synonym s : t.getSynonyms()) {
                s.setEncoding(StringEscapeUtils.escapeXml((String)s.getEncoding()));
                s.setTerm(StringEscapeUtils.escapeXml((String)s.getTerm()));
            }
        }
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/templates/terms.xml.st")));
        st.setAttribute("terms", (Object)terms);
        ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(vocabularyId, "//TERMS", st.toString());
        IOUtils.copy((Reader)new StringReader("Vocabulary saved correctly!"), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/commitVocabularyInfo"}, method={RequestMethod.POST})
    public void commitVocabularyInfo(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws IOException, ISRegistryException, JAXBException {
        log.info((Object)("committing vocabulary info id = " + vocabularyId));
        Vocabulary voc = (Vocabulary)new Gson().fromJson((Reader)request.getReader(), Vocabulary.class);
        String xml = "<VOCABULARY_DESCRIPTION>{desc}</VOCABULARY_DESCRIPTION>";
        xml = xml.replace("{desc}", StringEscapeUtils.escapeXml((String)voc.getDescription()));
        ((ISRegistryService)this.registryLocator.getService()).updateProfileNode(vocabularyId, "//VOCABULARY_DESCRIPTION", xml);
        IOUtils.copy((Reader)new StringReader("Vocabulary info saved correctly!"), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/createVocabulary"}, method={RequestMethod.POST})
    public void createVocabulary(HttpServletResponse response, HttpServletRequest request) throws IOException, ISRegistryException, JAXBException {
        log.info((Object)"create vocabulary");
        Vocabulary voc = (Vocabulary)new Gson().fromJson((Reader)request.getReader(), Vocabulary.class);
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/functionality/modular/templates/vocabulary.xml.st")));
        st.setAttribute("name", (Object)voc.getName());
        st.setAttribute("description", (Object)voc.getDescription());
        st.setAttribute("code", (Object)voc.getCode());
        st.setAttribute("date", (Object)DateUtils.now_ISO8601());
        String newVocabularyId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(st.toString());
        IOUtils.copy((Reader)new StringReader(newVocabularyId), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/dropVocabulary"}, method={RequestMethod.GET})
    public void dropVocabulary(HttpServletResponse response, HttpServletRequest request, @RequestParam(value="vocabularyId", required=true) String vocabularyId) throws IOException, ISRegistryException, JAXBException {
        log.info((Object)("delete vocabulary id=" + vocabularyId));
        ((ISRegistryService)this.registryLocator.getService()).deleteProfile(vocabularyId);
    }
}

