var module = angular.module('vocabulariesUI', []);

module.directive('tooltip', function() {
	return {
		restrict : 'A',
		link : function(scope, element, attrs) {
			$(element).tooltip();
		}
	}
});

module.directive('uniqueTerm', function() {
      return {
        restrict: 'A',
        require: 'ngModel',
        link: function (scope, element, attrs, ngModel) {
	            function validateTerm() {
	            	ngModel.$setValidity('unique', true);
	            	if (!scope.modalTerm.englishName || (scope.selectedTermIndex != -1 && scope.modalTerm.englishName.toLowerCase() == scope.entries[scope.selectedTermIndex].englishName.toLowerCase())) {
	            		return;
	            	}
	            	for (i in scope.entries) {
	            		if (scope.entries[i].englishName.toLowerCase() == scope.modalTerm.englishName.toLowerCase()) {
	            			ngModel.$setValidity('unique', false);
	            			return;
	            		}
	            		for (j in scope.entries[i].synonyms) {
	            			if (scope.entries[i].synonyms[j].term.toLowerCase() == scope.modalTerm.englishName.toLowerCase()) {
		            			ngModel.$setValidity('unique', false);
		            			return;
		            		}
	            		}
	            	}
	            }
	            
	            // register callback (validate) for $scope.modalTerm.englishName
	            scope.$watch( 
	        		function() {
	        			return scope.modalTerm.englishName;
	        		}, validateTerm);
	        }
      };
});

module.directive('uniqueCode', function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function (scope, element, attrs, ngModel) {
	          function validateCode() {
		          	ngModel.$setValidity('unique', true);
		          	if (!scope.modalTerm.code || (scope.selectedTermIndex != -1 && scope.modalTerm.code.toLowerCase() == scope.entries[scope.selectedTermIndex].code.toLowerCase())) {
		          		return;
		          	}
		          	for (i in scope.entries) {
		          		if (scope.modalTerm.code.toLowerCase() == scope.entries[i].code.toLowerCase()) {
		          			ngModel.$setValidity('unique', false);
		          		}
		          	}
	          	}
	
	          // register callback (validate) for $scope.modalTerm.code
	          scope.$watch( 
	          		function() {
	          			return scope.modalTerm.code;
	          		}, validateCode);
	      	}
    };
});

module.directive('uniqueSynonym', function() {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function (scope, element, attrs, ngModel) {
	    	  function validateSynonym() {
	    		  ngModel.$setValidity('unique', true);
	          		if (!scope.modalSynonym.term || (scope.selectedSynonymIndex != -1 && scope.modalSynonym.term.toLowerCase() == scope.entries[scope.selectedTermIndex].synonyms[scope.selectedSynonymIndex].term.toLowerCase())) {
	          			return;
	          		}
	          		for (i in scope.entries) {
		          		for (j in scope.entries[i].synonyms) {
		          			if (scope.entries[i].synonyms[j].term.toLowerCase() == scope.modalSynonym.term.toLowerCase()) {
		            			ngModel.$setValidity('unique', false);
		            			return;
		            		}
		          		}
	          		}
	          	}
	          
	          	// register callback (validate) for $scope.modalTerm.englishName
	          	scope.$watch( 
		      		function() {
		      			return scope.modalSynonym.term;
		      		}, validateSynonym);
	      }
    };
});

module.controller('vocabulariesCtrl', function ($scope, $http) {
	$scope.entries = [];
	$scope.modalSynonym = {};
	$scope.modalTerm = {};
	$scope.modalInfo = {};

	initSpinner();
	showSpinner();
	$http.get('vocabularies.json')
		.success(
			function(data) {
				$scope.vocabularies = data;
				hideSpinner();
			})
		.error(
			function() {
				show_notification("error", "Something really bad must have happened to our fellow hamster..");
				hideSpinner();
			});

	/*---------LOAD TERMS---------*/
	$scope.loadTerms = function(vocabularyId) {
		// check if same vocabulary
		if (vocabularyId == $scope.selectedVocabularyId) {
			return;
		}
		// prompt for uncommitted changes
		if (probePermanotice() == true) {
			var r=confirm("Switching vocabulary means losing uncommitted changes.. Are you fine with that?");
			if (r == false) {
				return;
			}
		}
		//actually load terms
		showSpinner();
		$http.get('terms.json?vocabularyId=' + vocabularyId)
			.success(
				function(data) {
					$scope.selectedVocabularyId = vocabularyId;
					$scope.entries = data;
					$scope.termFilter = "";
					hidePermanotice();
					hideSpinner();
				})
			.error(
				function() {
					show_notification("error","Something really bad must have happened to our fellow hamster..");
					hideSpinner();
				});
	}
	
	$scope.reloadTerms = function() {
		$scope.loadTerms($scope.selectedVocabularyId);
	}

	/*---------DELETE---------*/
	$scope.deleteTerm = function(term) {
		var index = $scope.entries.indexOf(term);
		$scope.entries.splice(index, 1);
		showPermanotice("Uncommitted changes!");
	}

	$scope.deleteSynonym = function(term, synonym) {
		var termIndex = $scope.entries.indexOf(term);
		var synonymIndex = $scope.entries[termIndex].synonyms.indexOf(synonym);
		$scope.entries[termIndex].synonyms.splice(synonymIndex, 1);
		showPermanotice("Uncommitted changes!");
	}

	$scope.dropVocabulary = function() {
		showSpinner();
		$http.get('dropVocabulary?vocabularyId=' + $scope.selectedVocabularyId)
			.success(
				function() {
					delete $scope.vocabularies[$scope.selectedVocabularyId];
					$scope.selectedVocabularyId = null;
					show_notification('success', "Vocabulary deleted successfully!");
					hideSpinner();
				})
			.error(
				function() {
					hideSpinner();
					show_notification('error', "Something really bad must have happened to our fellow hamster..");
				});
	}

	/*---------ADD/EDIT---------*/
	$scope.showInfoModal = function() {
		if ($scope.selectedVocabularyId != null) {
			// show modal for editing info of existing vocabulary
			$scope.modalInfo.name = $scope.vocabularies[$scope.selectedVocabularyId].name;
			$scope.modalInfo.code = $scope.vocabularies[$scope.selectedVocabularyId].code;
			$scope.modalInfo.description = $scope.vocabularies[$scope.selectedVocabularyId].description;
		} else {
			// show modal for new vocabulary
			$scope.modalInfo.name = '';
			$scope.modalInfo.code = '';
			$scope.modalInfo.description = '';
			hidePermanotice();
		}
		$('#infoModal').modal();
	}

	$scope.showTermModal = function(term) {
		$scope.selectedTermIndex = $scope.entries.indexOf(term);
		if (term != null) {
			// edit existing term
			$scope.modalTerm.englishName = term.englishName;
			$scope.modalTerm.nativeName = term.nativeName;
			$scope.modalTerm.encoding = term.encoding;
			$scope.modalTerm.code = term.code;
		} else {
			// edit new term
			$scope.modalTerm.englishName = '';
			$scope.modalTerm.nativeName = '';
			$scope.modalTerm.encoding = '';
			$scope.modalTerm.code = '';
		}
		$('#termModal').modal();
	}

	$scope.showSynonymModal = function(term, synonym) {
		$scope.selectedTermIndex = $scope.entries.indexOf(term);
		$scope.selectedSynonymIndex = $scope.entries[$scope.selectedTermIndex].synonyms.indexOf(synonym);
		if (synonym != null) {
			// edit existing synonym
			$scope.modalSynonym.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
			$scope.modalSynonym.term = $scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].term;
			$scope.modalSynonym.encoding = $scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].encoding;
		} else {
			// new synonym
			$scope.modalSynonym.refTerm = $scope.entries[$scope.selectedTermIndex].englishName;
			$scope.modalSynonym.term = '';
			$scope.modalSynonym.encoding = '';
		}
		$('#synonymModal').modal();
	}

	$scope.editInfo = function() {
		showSpinner();
		if ($scope.selectedVocabularyId == null) {
			// new vocabulary
			$http.post('createVocabulary', {"name" : $scope.modalInfo.name, "code" : $scope.modalInfo.code, "description" : $scope.modalInfo.description})
				.success(
					function(data) {
						show_notification("success", "Vocabulary created successfully!");
						$scope.vocabularies[data] = {
							"id" : data,
							"name" : $scope.modalInfo.name,
							"code" : $scope.modalInfo.code,
							"description" : $scope.modalInfo.description
						};
						hideSpinner();
					})
				.error(
					function() {
						show_notification("error", "Something really bad must have happened to our fellow hamster..");
						hideSpinner();
					});
		} else {
			// edit vocabulary
			$http.post('commitVocabularyInfo?vocabularyId=' + $scope.selectedVocabularyId, {	
						"name" : $scope.modalInfo.name, 
						"code" : $scope.modalInfo.code, 
						"description" : $scope.modalInfo.description})
				.success(
					function(data) {
						// update model
						$scope.vocabularies[$scope.selectedVocabularyId].name = $scope.modalInfo.name;
						$scope.vocabularies[$scope.selectedVocabularyId].code = $scope.modalInfo.code;
						$scope.vocabularies[$scope.selectedVocabularyId].description = $scope.modalInfo.description;
						show_notification("success", data);
						hideSpinner();
					})
				.error(
					function() {
						show_notification("error", "Something really bad must have happened to our fellow hamster..");
						hideSpinner();
					});
		}
		// dismiss modal
		$('.modal').modal('hide');
	}

	$scope.editTerm = function() {
		if ($scope.selectedTermIndex == -1) {
			// new term
			$scope.entries.push({
				"englishName" : $scope.modalTerm.englishName,
				"nativeName" : $scope.modalTerm.nativeName,
				"encoding" : $scope.modalTerm.encoding,
				"synonyms" : [],
				"code" : $scope.modalTerm.code
			});
		} else {
			// term update
			$scope.entries[$scope.selectedTermIndex].englishName = $scope.modalTerm.englishName;
			$scope.entries[$scope.selectedTermIndex].nativeName = $scope.modalTerm.nativeName;
			$scope.entries[$scope.selectedTermIndex].encoding = $scope.modalTerm.encoding;
			$scope.entries[$scope.selectedTermIndex].code = $scope.modalTerm.code;
		}
		// dismiss modal
		$('.modal').modal('hide');
		showPermanotice("Uncommitted changes!");
	}

	$scope.editSynonym = function() {
		if ($scope.selectedSynonymIndex == -1) {
			$scope.entries[$scope.selectedTermIndex].synonyms.push({
				"term" : $scope.modalSynonym.term,
				"encoding" : $scope.modalSynonym.encoding
			});
		} else {
			$scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].term = $scope.modalSynonym.term
			$scope.entries[$scope.selectedTermIndex].synonyms[$scope.selectedSynonymIndex].encoding = $scope.modalSynonym.encoding;
		}
		// dismiss modal
		$('.modal').modal('hide');
		showPermanotice("Uncommitted changes!");
	}

	/*---------COMMIT---------*/
	$scope.commit = function() {
		showSpinner();
		$http.post('commitVocabulary?vocabularyId=' + $scope.selectedVocabularyId, $scope.entries)
			.success(
				function(data) {
					show_notification("success", data);
					hideSpinner();
					hidePermanotice();
					$scope.reloadTerms();
				})
			.error(
				function() {
					show_notification("error", "Something really bad must have happened to our fellow hamster..");
					showPermanotice("Uncommitted changes!");
					hideSpinner();
				});
	}
});

