$common/master( header={
<script type="text/javascript" src="file.get?src=angular.min.js"></script>
<script type="text/javascript" src="file.get?src=vocabularies.js"></script>
<link rel="stylesheet" type="text/css" href="file.get?src=vocabularies.css">
}, body={
<div class="main" ng-app="vocabulariesUI" ng-controller="vocabulariesCtrl">
	<div class="box">
		<div class="row-fluid">
			<div class="column span3 bs-docs-sidebar">
				<p class="offset1 span10 ">
					<button class="btn btn-primary" ng-click="selectedVocabularyId = null; showInfoModal()" tooltip rel="tooltip"
						data-placement="right" title="New vocabulary">
						<i class="icon-white icon-plus"></i>
					</button>
				</p>
				<ul class="offset1 span10 nav nav-list bs-docs-sidenav">
					<li ng-repeat="(vocId, voc) in vocabularies"
						ng-class="{active: voc.id == selectedVocabularyId}"
						ng-click="loadTerms(voc.id)"><a>{{voc.name}}<i class="icon-chevron-right"></i></a></li>
				</ul>
			</div>

			<div class="column span9">
				<legend>Vocabulary Editor</legend>
				<div ng-show="entries != null && selectedVocabularyId" class="span11">
					<form class="form-search">
						<button class="btn btn-primary" ng-click="showInfoModal()" tooltip
							rel="tooltip" title="Edit info" data-placement="bottom">
							<i class="icon-white icon-info-sign"></i>
						</button>
						<button class="btn btn-primary" ng-click="showTermModal(null)" tooltip
							rel="tooltip" data-placement="bottom" title="New term">
							<i class="icon-white icon-plus"></i>
						</button>
						<button class="btn btn-success" ng-click="commit()" tooltip
							rel="tooltip" data-placement="bottom" title="Commit">
							<i class="icon-white icon-ok"></i>
						</button>
						<button class="btn btn-warning" ng-click="reloadTerms()" tooltip
							rel="tooltip" data-placement="bottom" title="Discard all">
							<i class="icon-white icon-repeat"></i>
						</button>
						<button class="btn btn-danger" ng-click="dropVocabulary()" tooltip rel="tooltip"
							data-placement="bottom" title="Drop vocabulary">
							<i class="icon-white icon-trash"></i>
						</button>

						<input type="text" class="input-medium search-query pull-right"
							ng-model="termFilter" placeholder="Filter by...">
					</form>
					<div class="accordion" id="TermsAccordion">
						<div ng-repeat="term in entries | filter:termFilter"
							class="accordion-group">
							<div class="accordion-heading">
								<div class="accordion-toggle group-accordion-toggle">
									<a class="span11" data-toggle="collapse"
										data-parent="TermsAccordion" href="#accordionTerm{{\$index}}">{{term.englishName}}</a>
									<button class="btn btn-primary btn-mini"
										ng-click="showTermModal(term)" tooltip rel="tooltip"
										data-placement="right" title="Edit term">
										<i class="icon-white icon-pencil"></i>
									</button>
									<button class="btn btn-mini btn-danger"
										ng-click="deleteTerm(term)" tooltip rel="tooltip"
										data-placement="right" title="Delete term">
										<i class="icon-white icon-remove"></i>
									</button>
								</div>
							</div>
							<div id="accordionTerm{{\$index}}"
								class="accordion-body collapse">
								<div class="accordion-inner">
									<table class="table table-bordered">
										<th>Synonym</th>
										<th>Encoding</th>
										<th>Operation</th>
										<tr ng-repeat="synonym in term.synonyms">
											<td class="span6">{{synonym.term}}</td>
											<td class="span3">{{synonym.encoding}}</td>
											<td class="span2">
												<button class="btn btn-primary btn-mini"
													ng-click="showSynonymModal(term, synonym)"
													tooltip rel="tooltip" data-placement="bottom"
													title="Edit synonym">
													<i class="icon-white icon-pencil"></i>
												</button>
												<button class="btn btn-danger btn-mini"
													ng-click="deleteSynonym(term, synonym)" tooltip
													rel="tooltip" data-placement="bottom"
													title="Delete synonym">
													<i class="icon-white icon-remove"></i>
												</button>
											</td>
										</tr>
									</table>
									<button class="btn btn-primary btn-mini" type="button"
										ng-click="showSynonymModal(term, null)" tooltip
										rel="tooltip" data-placement="right" title="Add new synonym">
										<i class="icon-white icon-plus"></i>
									</button>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- span9 -->
			
			<!-- infoModal -->
			<div id="infoModal" class="modal hide fade" tabindex="-1"
				role="dialog" aria-labelledby="infoModalLabel" aria-hidden="true">
				<form name="infoForm" class="modal-form form-horizontal" ng-submit="editInfo()">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h3 id="termModalLabel">vocabulary information</h3>
					</div>
					<div class="modal-body">
						<div class="control-group">
							<label class="control-label" for="vocabularyName">Vocabulary name</label>
							<div class="controls">
								<input class="input" ng-disabled="selectedVocabularyId" required type="text" name="vocabularyName" placeholder="vocabulary name" ng-model="modalInfo.name">
							</div>
						</div>
						<div class="control-group">
							<label class="control-label" for="vocabularyCode">Vocabulary code</label>
							<div class="controls">
								<input class="input" ng-disabled="selectedVocabularyId" required type="text" name="vocabularyCode" placeholder="vocabulary code" ng-model="modalInfo.code">
							</div>
						</div>
						<div class="control-group">
							<label class="control-label" for="vocabularyDescription">Vocabulary description</label>
							<div class="controls">
								<textarea rows="3" type="text" name="vocabularyDescription" placeholder="vocabulary description" ng-model="modalInfo.description"></textarea>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button class="btn btn-primary" type="submit">Save</button>
					</div>
				</form>
			</div>

			<!-- termModal -->
			<div id="termModal" class="modal hide fade" tabindex="-1"
				role="dialog" aria-labelledby="termModalLabel" aria-hidden="true">
				<form name="termForm" class="modal-form form-horizontal" ng-submit="editTerm()">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h3 id="termModalLabel">Term editor</h3>
					</div>
					<div class="modal-body">
						<div class="control-group" ng-class="{error: termForm.englishName.\$error.unique}">
							<label class="control-label" for="englishName">English name</label>
							<div class="controls">
								<input unique-term required type="text" name="englishName" placeholder="english name" ng-model="modalTerm.englishName">
								<span ng-show="termForm.englishName.\$error.unique"><strong class="text-error">Duplicate!</strong></span>
							</div>
						</div>
						<div class="control-group" ng-class="{error: termForm.code.\$error.unique}">
							<label class="control-label" for="code">Code</label>
							<div class="controls">
								<input unique-code ng-disabled="selectedTermIndex != -1" required type="text" name="code" placeholder="code" ng-model="modalTerm.code">
								<span ng-show="termForm.code.\$error.unique"><strong class="text-error">Duplicate!</strong></span>
							</div>
						</div>
						<div class="control-group">
							<label class="control-label" for="nativeName">Native name</label>
							<div class="controls">
								<input type="text" name="nativeName" placeholder="native name" ng-model="modalTerm.nativeName">
							</div>
						</div>
						<div class="control-group">
							<label class="control-label" for="encoding">Encoding</label>
							<div class="controls">
								<input type="text" name="encoding" placeholder="encoding" ng-model="modalTerm.encoding">
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button class="btn btn-primary" type="submit" ng-disabled="!termForm.englishName.\$error.unique != true">Save</button>
					</div>
				</form>
			</div>

			<!-- synonymModal -->
			<div id="synonymModal" class="modal hide fade" tabindex="-1"
				role="dialog" aria-labelledby="synonymModalLabel" aria-hidden="true">
				<form name="synonymForm" class="modal-form form-horizontal" ng-submit="editSynonym()">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
						<h3 id="synonymModalLabel">Synonym editor</h3>
					</div>
					<div class="modal-body">
						<div class="control-group">
							<label class="control-label" for="refterm">Ref. Term</label>
							<div class="controls">
								<span id="refterm" class="input uneditable-input">{{modalSynonym.refTerm}}</span>
							</div>
						</div>
						<div class="control-group" ng-class="{error: synonymForm.term.\$error.unique}">
							<label class="control-label" for="term">Term</label>
							<div class="controls">
								<input unique-synonym required name="term" type="text" placeholder="new synonym" ng-model="modalSynonym.term">
								<span ng-show="synonymForm.term.\$error.unique"><strong class="text-error">Duplicate!</strong></span>
							</div>
						</div>
						<div class="control-group">
							<label class="control-label" for="encoding">Encoding</label>
							<div class="controls">
								<input name="encoding" type="text" placeholder="encoding" ng-model="modalSynonym.encoding">
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button class="btn btn-primary" ng-disabled="!synonymForm.term.\$error.unique != true" type="submit">Save</button>
					</div>
				</form>
			</div>
		</div>
		<!-- row-fluid -->
	</div>
	<!-- box -->
</div>

} )$
