package eu.dnetlib.functionality.modular.ui.vocabularies.adapters;

import com.google.common.base.Function;

import eu.dnetlib.functionality.modular.ui.vocabularies.controllers.VocabulariesController;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Synonym;

/**
 * This class is used in {@link VocabulariesController} when un-marshaling of
 * a {@link Synonym} object is needed.
 * @author Andrea Mannocci
 *
 */
public class SynonymAdapter implements Function<String, Synonym>{

	@Override
	public Synonym apply(String s) {
		String[] tokens = s.split("§§§");
		return new Synonym(tokens[0].trim(), tokens[1].trim());
	}

}
