package eu.dnetlib.functionality.modular.ui.vocabularies.adapters;

import com.google.common.base.Function;

import eu.dnetlib.functionality.modular.ui.vocabularies.controllers.VocabulariesController;
import eu.dnetlib.functionality.modular.ui.vocabularies.model.Term;

/**
 * This class is used in {@link VocabulariesController} when un-marshaling of a {@link Term} object is needed.
 * 
 * @author Andrea Mannocci
 * 
 */
public class TermAdapter implements Function<String, Term> {

	@Override
	public Term apply(final String s) {
		String[] tokens = s.split("§§§");
		return new Term(tokens[0].trim(), tokens[1].trim(), tokens[2].trim(), tokens[3].trim());
	}

}
