/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.datasources.SimpleDatasourceMagerUtils;
import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerService;
import eu.dnetlib.enabling.datasources.rmi.DatasourceManagerServiceException;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class DatasourceManagerServiceImpl
extends AbstractBaseService
implements DatasourceManagerService {
    private ServiceLocator<ISRegistryService> registryLocator;
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(DatasourceManagerServiceImpl.class);
    private static final String REPOSITORY_SERVICE_RESOURCE_TYPE = "RepositoryServiceResourceType";
    private static SAXReader reader = new SAXReader();

    public boolean addDatasource(DatasourceDesc ds) throws DatasourceManagerServiceException {
        try {
            String profile = SimpleDatasourceMagerUtils.toDatasourceProfile(ds);
            log.debug((Object)("Generated profile: " + profile));
            String profId = ((ISRegistryService)this.registryLocator.getService()).registerProfile(profile);
            log.info((Object)("A new datasource has been registered with profile ID: " + profId));
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error adding a datasource", (Throwable)e);
            throw new DatasourceManagerServiceException("Error adding a datasource", (Throwable)e);
        }
    }

    public boolean deleteDatasource(String dsId) throws DatasourceManagerServiceException {
        try {
            return ((ISRegistryService)this.getRegistryLocator().getService()).deleteProfile(this.findProfileId(dsId));
        }
        catch (Exception e) {
            log.error((Object)("Error deleting profile: " + dsId));
            throw new DatasourceManagerServiceException("Error deleting profile: " + dsId, (Throwable)e);
        }
    }

    public DatasourceDesc getDatasource(String dsId) throws DatasourceManagerServiceException {
        try {
            return SimpleDatasourceMagerUtils.toDatasourceDesc(this.findProfile(dsId));
        }
        catch (Exception e) {
            log.error((Object)("Error fetching datasource " + dsId));
            throw new DatasourceManagerServiceException("Error fetching datasource " + dsId, (Throwable)e);
        }
    }

    public List<DatasourceDesc> listAllDatasources() throws DatasourceManagerServiceException {
        String xquery = "/*[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType']";
        return this.listDatasourcesUsingQuery("/*[.//RESOURCE_TYPE/@value='RepositoryServiceResourceType']");
    }

    public List<DatasourceDesc> listDatasourcesUsingFilter(String compliance, String contentDescription, String iisProcessingWorkflow, String collectedFrom) throws DatasourceManagerServiceException {
        StringWriter swCond = new StringWriter();
        swCond.append(".//RESOURCE_TYPE/@value='RepositoryServiceResourceType'");
        if (compliance != null && !compliance.isEmpty()) {
            swCond.append(" and .//INTERFACE/@compliance='" + compliance + "'");
        }
        if (contentDescription != null && !contentDescription.isEmpty()) {
            swCond.append(" and .//INTERFACE/@contentDescription='" + contentDescription + "'");
        }
        if (iisProcessingWorkflow != null && !iisProcessingWorkflow.isEmpty()) {
            swCond.append(" and .//FIELD[./key='iis_processing_workflow']/value='" + iisProcessingWorkflow + "'");
        }
        if (collectedFrom != null && !collectedFrom.isEmpty()) {
            swCond.append(" and .//DATASOURCE_ORIGINAL_ID/@provenance = '" + collectedFrom + "'");
        }
        return this.listDatasourcesUsingQuery("/*[" + swCond.toString() + "]");
    }

    public synchronized boolean updateActivationStatus(String dsId, String ifaceId, boolean active) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            ((Element)prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']")).addAttribute("active", Boolean.toString(active));
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating profile " + dsId, (Throwable)e);
        }
    }

    public synchronized boolean updateLevelOfCompliance(String dsId, String ifaceId, String level) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            ((Element)prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']")).addAttribute("compliance", level);
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating profile " + dsId, (Throwable)e);
        }
    }

    public boolean updateBaseUrl(String dsId, String ifaceId, String baseUrl) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/BASE_URL").setText(baseUrl);
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Error updating profile " + dsId));
                throw new DatasourceManagerServiceException("Error updating profile " + dsId, (Throwable)e);
            }
            catch (Exception e2) {
                log.error((Object)"");
                throw new DatasourceManagerServiceException("", (Throwable)e2);
            }
        }
    }

    public boolean updateContentDescription(String dsId, String ifaceId, String desc) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            ((Element)prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']")).addAttribute("contentDescription", desc);
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating profile " + dsId, (Throwable)e);
        }
    }

    public boolean setIisProcessingWorkflow(String dsId, String ifaceId, String wf) throws DatasourceManagerServiceException {
        return this.updateExtraField(dsId, ifaceId, "iis_processing_workflow", wf, false);
    }

    public synchronized boolean addInterface(String dsId, IfaceDesc iface) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            ((Element)prof.selectSingleNode("//INTERFACES")).add(SimpleDatasourceMagerUtils.toInterfaceNode(iface));
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error adding an interface to ds " + dsId));
            throw new DatasourceManagerServiceException("Error adding an interface to ds " + dsId, (Throwable)e);
        }
    }

    public synchronized boolean deleteInterface(String dsId, String ifcId) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            prof.selectSingleNode("//INTERFACE[@id='" + ifcId + "']").detach();
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)"");
            throw new DatasourceManagerServiceException("", (Throwable)e);
        }
    }

    public synchronized boolean updateExtraField(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            SimpleDatasourceMagerUtils.addOrupdateExtraField(prof, field, value);
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating extrafield in profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating extrafield in profile " + dsId, (Throwable)e);
        }
    }

    public synchronized boolean updateAccessParam(String dsId, String ifaceId, String field, String value, boolean preserveOriginal) throws DatasourceManagerServiceException {
        try {
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            Element node = (Element)prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/ACCESS_PROTOCOL");
            if (node != null) {
                node.setText(value);
                node.addAttribute(field, value);
            }
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating accessparam in profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating accessparam in profile " + dsId, (Throwable)e);
        }
    }

    public synchronized boolean deleteAccessParamOrExtraField(String dsId, String ifaceId, String field) throws DatasourceManagerServiceException {
        try {
            Node nodeEF;
            Document prof = this.findProfile(dsId);
            String profId = prof.valueOf("//RESOURCE_IDENTIFIER/@value");
            Node nodeAP = prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/ACCESS_PROTOCOL/@" + field);
            if (nodeAP != null) {
                nodeAP.detach();
            }
            if ((nodeEF = prof.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']/INTERFACE_EXTRA_FIELD[@name='" + field + "']")) != null) {
                nodeEF.detach();
            }
            return ((ISRegistryService)this.registryLocator.getService()).updateProfile(profId, prof.asXML(), REPOSITORY_SERVICE_RESOURCE_TYPE);
        }
        catch (Exception e) {
            log.error((Object)("Error updating accessparam in profile " + dsId));
            throw new DatasourceManagerServiceException("Error updating accessparam in profile " + dsId, (Throwable)e);
        }
    }

    private Document findProfile(String dsId) throws DatasourceManagerServiceException {
        try {
            String profile = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("/*[.//DATASOURCE_ORIGINAL_ID  = '" + dsId + "']");
            return reader.read((Reader)new StringReader(profile));
        }
        catch (Exception e) {
            throw new DatasourceManagerServiceException("Error finding  profile " + dsId, (Throwable)e);
        }
    }

    private String findProfileId(String dsId) throws DatasourceManagerServiceException {
        try {
            return ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("/*[.//DATASOURCE_ORIGINAL_ID = '" + dsId + "']//RESOURCE_IDENTIFIER/@value/string()");
        }
        catch (Exception e) {
            throw new DatasourceManagerServiceException("Error finding id of profile " + dsId, (Throwable)e);
        }
    }

    public List<DatasourceDesc> listDatasourcesUsingQuery(String xquery) throws DatasourceManagerServiceException {
        try {
            ArrayList list = Lists.newArrayList();
            for (String prof : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile(xquery)) {
                list.add(SimpleDatasourceMagerUtils.toDatasourceDesc(reader.read((Reader)new StringReader(prof))));
            }
            return list;
        }
        catch (Exception e) {
            log.error((Object)("Error obtaining datasource list using query: " + xquery));
            throw new DatasourceManagerServiceException("Error obtaining datasource list", (Throwable)e);
        }
    }

    public boolean updateSQL(String dsId, String sql, boolean delete) throws DatasourceManagerServiceException {
        throw new DatasourceManagerServiceException("NOT IMPLEMENTED");
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

