/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import eu.dnetlib.enabling.datasources.rmi.DatasourceDesc;
import eu.dnetlib.enabling.datasources.rmi.IfaceDesc;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SimpleDatasourceMagerUtils {
    private static final Resource datasourceTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/tmpl/datasource.tmpl.xml");
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public static DatasourceDesc toDatasourceDesc(Document doc) {
        DatasourceDesc ds = new DatasourceDesc();
        ds.setDatasourceClass(doc.valueOf("//DATASOURCE_TYPE"));
        ds.setDatasourceClass(doc.valueOf("//DATASOURCE_TYPE"));
        ds.setId(doc.valueOf("//DATASOURCE_ORIGINAL_ID"));
        ds.setCollectedFrom(doc.valueOf("//DATASOURCE_ORIGINAL_ID/@provenance"));
        ds.setTypology(doc.valueOf("//TYPOLOGY"));
        ds.setOfficialName(doc.valueOf("//OFFICIAL_NAME"));
        ds.setEnglishName(doc.valueOf("//ENGLISH_NAME"));
        ds.setLogoUrl(doc.valueOf("//ICON_URI"));
        ds.setCountryCode(doc.valueOf("//COUNTRY[string-length(text()) = 2]"));
        ds.setCountryName(doc.valueOf("//COUNTRY[string-length(text()) > 2]"));
        ds.setLongitude(Double.valueOf(SimpleDatasourceMagerUtils.parseDouble(doc.valueOf("//LONGITUDE"), 0.0)));
        ds.setLatitude(Double.valueOf(SimpleDatasourceMagerUtils.parseDouble(doc.valueOf("//LATITUDE"), 0.0)));
        ds.setTimezone(Double.valueOf(SimpleDatasourceMagerUtils.parseDouble(doc.valueOf("//TIMEZONE"), 0.0)));
        ds.setWebsiteUrl(doc.valueOf("//REPOSITORY_WEBPAGE"));
        ds.setOrganization(doc.valueOf("//REPOSITORY_INSTITUTION"));
        ds.setContactEmail(doc.valueOf("//ADMIN_INFO"));
        ds.setRegisteredBy(doc.valueOf("//REGISTERED_BY"));
        ds.setInterfaces(new ArrayList());
        for (Object o : doc.selectNodes("//INTERFACE")) {
            ds.getInterfaces().add(SimpleDatasourceMagerUtils.toInterfaceDesc((Element)o));
        }
        ds.setNamespacePrefix(doc.valueOf("//FIELD[./key='NamespacePrefix']/value"));
        ds.setDateOfValidation(SimpleDatasourceMagerUtils.parseDate(doc.valueOf("//FIELD[./key='dateOfValidation']/value"), null));
        ds.setDateOfCollection(SimpleDatasourceMagerUtils.parseDate(doc.valueOf("//FIELD[./key='dateOfCollection']/value"), null));
        ds.setMergehomonyms(Boolean.valueOf(SimpleDatasourceMagerUtils.parseBoolean(doc.valueOf("//FIELD[./key='mergeHomonyms']/value"), true)));
        ds.setAggregator(doc.valueOf("//FIELD[./key='aggregatorName']/value"));
        return ds;
    }

    public static String toDatasourceProfile(DatasourceDesc ds) throws IOException, DocumentException {
        Document doc = new SAXReader().read(datasourceTmpl.getInputStream());
        doc.selectSingleNode("//DATASOURCE_TYPE").setText(ds.getDatasourceClass());
        doc.selectSingleNode("//DATASOURCE_ORIGINAL_ID").setText(ds.getId());
        doc.selectSingleNode("//DATASOURCE_ORIGINAL_ID/@provenance").setText(ds.getCollectedFrom());
        doc.selectSingleNode("//TYPOLOGY").setText(ds.getTypology());
        doc.selectSingleNode("//OFFICIAL_NAME").setText(ds.getOfficialName());
        doc.selectSingleNode("//ENGLISH_NAME").setText(ds.getEnglishName());
        doc.selectSingleNode("//ICON_URI").setText(ds.getLogoUrl());
        doc.selectSingleNode("//COUNTRY").setText(ds.getCountryName() != null ? ds.getCountryName() : ds.getCountryCode());
        doc.selectSingleNode("//LONGITUDE").setText("" + ds.getLongitude());
        doc.selectSingleNode("//LATITUDE").setText("" + ds.getLatitude());
        doc.selectSingleNode("//TIMEZONE").setText("" + ds.getTimezone());
        doc.selectSingleNode("//REPOSITORY_WEBPAGE").setText(ds.getWebsiteUrl());
        doc.selectSingleNode("//REPOSITORY_INSTITUTION").setText(ds.getOrganization());
        doc.selectSingleNode("//ADMIN_INFO").setText(ds.getContactEmail());
        doc.selectSingleNode("//REGISTERED_BY").setText(ds.getRegisteredBy());
        doc.selectSingleNode("//LAST_UPDATE/@value").setText(DateUtils.now_ISO8601());
        if (ds.getInterfaces() != null) {
            Element ifaces = (Element)doc.selectSingleNode("//INTERFACES");
            for (IfaceDesc ifc : ds.getInterfaces()) {
                ifaces.add(SimpleDatasourceMagerUtils.toInterfaceNode(ifc));
                if (ifc.getExtraFields() == null) continue;
                for (Map.Entry e : ifc.getExtraFields().entrySet()) {
                    SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, (String)e.getKey(), (String)e.getValue());
                }
            }
        }
        if (ds.getNamespacePrefix() != null) {
            SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, "NamespacePrefix", ds.getNamespacePrefix());
        }
        if (ds.getDateOfValidation() != null) {
            SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, "dateOfValidation", dateFormatter.format(ds.getDateOfValidation()));
        }
        if (ds.getDateOfCollection() != null) {
            SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, "dateOfCollection", dateFormatter.format(ds.getDateOfCollection()));
        }
        if (ds.isMergehomonyms() != null) {
            SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, "mergeHomonyms", ds.isMergehomonyms().toString());
        }
        if (ds.getAggregator() != null) {
            SimpleDatasourceMagerUtils.addOrupdateExtraField(doc, "aggregatorName", ds.getAggregator());
        }
        return doc.asXML();
    }

    public static Element toInterfaceNode(IfaceDesc ifaceDesc) {
        Element iface = DocumentHelper.createElement((String)"INTERFACE");
        iface.addAttribute("id", ifaceDesc.getId());
        iface.addAttribute("label", ifaceDesc.getTypology() + " (" + ifaceDesc.getCompliance() + ")");
        iface.addAttribute("compliance", ifaceDesc.getCompliance());
        iface.addAttribute("typology", ifaceDesc.getTypology());
        iface.addAttribute("contentDescription", ifaceDesc.getContentDescription());
        iface.addAttribute("active", Boolean.toString(ifaceDesc.getActive()));
        iface.addAttribute("removable", Boolean.toString(ifaceDesc.getRemovable()));
        Element ap = iface.addElement("ACCESS_PROTOCOL");
        if (ifaceDesc.getAccessParams() != null) {
            for (Map.Entry e : ifaceDesc.getAccessParams().entrySet()) {
                ap.addAttribute((String)e.getKey(), (String)e.getValue());
            }
        }
        ap.setText(ifaceDesc.getAccessProtocol());
        iface.addElement("BASE_URL").setText(ifaceDesc.getBaseUrl());
        if (ifaceDesc.getExtraFields() != null) {
            for (Map.Entry e : ifaceDesc.getExtraFields().entrySet()) {
                Element ief = iface.addElement("INTERFACE_EXTRA_FIELD");
                ief.addAttribute("name", (String)e.getKey());
                ief.setText((String)e.getValue());
            }
        }
        return iface;
    }

    public static IfaceDesc toInterfaceDesc(Element elem) {
        IfaceDesc iface = new IfaceDesc();
        iface.setId(elem.valueOf("@id"));
        iface.setCompliance(elem.valueOf("@compliance"));
        iface.setTypology(elem.valueOf("@typology"));
        iface.setContentDescription(elem.valueOf("@contentDescription"));
        iface.setActive(SimpleDatasourceMagerUtils.parseBoolean(elem.valueOf("@active"), true));
        iface.setRemovable(SimpleDatasourceMagerUtils.parseBoolean(elem.valueOf("@removable"), true));
        iface.setBaseUrl(elem.valueOf("./BASE_URL"));
        iface.setAccessProtocol(elem.valueOf("./ACCESS_PROTOCOL"));
        iface.setAccessParams(new HashMap());
        iface.setExtraFields(new HashMap());
        for (Object o : elem.selectNodes("./ACCESS_PROTOCOL/@*")) {
            Attribute attr = (Attribute)o;
            iface.getAccessParams().put(attr.getName(), attr.getValue());
        }
        for (Object o : elem.selectNodes("./INTERFACE_EXTRA_FIELD")) {
            Element e = (Element)o;
            iface.getAccessParams().put(e.valueOf("@name"), e.getText());
        }
        return iface;
    }

    public static void addOrupdateExtraField(Document doc, String field, String value) {
        String val = value != null ? value : "";
        Node node = doc.selectSingleNode("//FIELD[./key='" + field + "']/value");
        if (node != null) {
            node.setText(val);
        } else {
            Element fields = (Element)doc.selectSingleNode("//EXTRA_FIELDS");
            Element f = fields.addElement("FIELD");
            f.addElement("key").setText(field);
            f.addElement("value").setText(val);
        }
    }

    private static Date parseDate(String s, Date defaultValue) {
        try {
            return dateFormatter.parse(s);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    private static boolean parseBoolean(String s, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    private static double parseDouble(String s, double defaultValue) {
        try {
            return Double.parseDouble(s);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }
}

