/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial.utils;

import java.io.File;
import java.io.IOException;

/**
 *
 * @author gathanas
 */
public class SQDiskMonitor {
   
   private String satelliteLocationPath;
   private String satelliteUtilityProcessPath;
   private String satelliteUtilityProcessKernelPath;
   private String satelliteTLEPath;
   private String satelliteListFilePath;
   
   public SQDiskMonitor() {
   }

   public File createReqSatelliteEpochFile(String queryId) throws IOException{
      String filePath  = satelliteLocationPath+File.separator+"request"+File.separator+queryId+File.separator+"epochs.txt";
      File requestEpochFile = new File(filePath);
      if(!requestEpochFile.exists()){
         requestEpochFile.getParentFile().mkdirs();
         requestEpochFile.createNewFile();
      }
      
      return requestEpochFile;
   }
   
   public File createReqSatelliteOutputFile(String queryId, String satelliteId) throws IOException{
      String filePath  = satelliteLocationPath+File.separator+"request"+File.separator+queryId+File.separator+satelliteId+".txt";
      File requestEpochFile = new File(filePath);
      if(!requestEpochFile.exists()){
         requestEpochFile.getParentFile().mkdirs();
         requestEpochFile.createNewFile();
      }
      return requestEpochFile;
   }
   
    public File createTrajectoryProcInputFile(String queryId, String satelliteName) throws IOException {
      String filePath  = satelliteLocationPath+File.separator+"request"+File.separator+queryId+File.separator+satelliteName+"_trajctory.nml";
      File requestEpochFile = new File(filePath);
      if(!requestEpochFile.exists()){
         requestEpochFile.getParentFile().mkdirs();
         requestEpochFile.createNewFile();
      }
      return requestEpochFile;
    }
    
    public void cleanupTempDiskSpace(){
       
    }

   
//   /////////////////////////////////////////////////////////////
//   Bean initialization code
   
   public String getSatelliteLocationPath() {
      return satelliteLocationPath;
   }

   public void setSatelliteLocationPath(String satelliteLocationPath) {
      this.satelliteLocationPath = satelliteLocationPath;
   }

   public String getSatelliteUtilityProcessPath() {
      return satelliteUtilityProcessPath;
   }

   public void setSatelliteUtilityProcessPath(String satelliteUtilityProcessPath) {
      this.satelliteUtilityProcessPath = satelliteUtilityProcessPath;
   }

    public String getSatelliteUtilityProcessKernelPath() {
        return satelliteUtilityProcessKernelPath;
    }

    public void setSatelliteUtilityProcessKernelPath(String satelliteUtilityProcessKernelPath) {
        this.satelliteUtilityProcessKernelPath = satelliteUtilityProcessKernelPath;
    }

   public String getSatelliteTLEPath() {
      return satelliteTLEPath;
   }

   public void setSatelliteTLEPath(String satelliteTLEPath) {
      this.satelliteTLEPath = satelliteTLEPath;
   }

   public String getSatelliteListFilePath() {
      return satelliteListFilePath;
   }

   public void setSatelliteListFilePath(String satelliteListFilePath) {
      this.satelliteListFilePath = satelliteListFilePath;
   }
   
   
}
