/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial.impl;

import eu.dnetlib.espas.spatial.TimePeriodConstraint;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.postgresql.util.PGInterval;

/**
 *
 * @author gathanas
 */
public class TimePeriodCalculator {

   public TimePeriodCalculator() {
   }

   public synchronized Period estimatePeriod(TimePeriodConstraint timeConstraint) {
//      todo provide a better estimation mechanism; this should consider Shannon's theorem on sampling + data provider's history
        int _days= Days.daysBetween(new DateTime(timeConstraint.getToDate().getTime()), new DateTime(timeConstraint.getFromDate().getTime())).getDays();
      if(_days<5)
         return Period.seconds(15*60);
      else if(_days>=5 && _days<10)
         return Period.seconds(90*60);
      else if(_days>=10 && _days<15)
         return Period.seconds(120*60);
      else if(_days>=15 && _days<20)
         return Period.seconds(150*60);
      else 
         return Period.seconds(180*60);
   }

   /** Returns a list of time periods including period start, mid and end timestamps
    */
   public synchronized List<Date[]> findPeriodicTimestamps(Date startDate, Date endDate, Period period) {
      List<Date[]> results = new LinkedList<Date[]>();
//      int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis
      DateTime current = new DateTime(startDate.getTime(), DateTimeZone.UTC);
      DateTime endDateTime = new DateTime(endDate.getTime(), DateTimeZone.UTC);

      while (current.isBefore(endDateTime) || current.isEqual(endDateTime)) {
         Date periodStart= current.toGregorianCalendar().getTime();
         Date periodMid = current.plus(new Duration(period.toStandardDuration().getMillis()/2)).toGregorianCalendar().getTime();
         Date periodEnd = current.plus(period).toGregorianCalendar().getTime();
         results.add(new Date[]{periodStart,periodMid,periodEnd});
         current = current.plus(period);
      }

      return results;
   }

}
