/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial.impl;

import eu.dnetlib.espas.spatial.QShape;
import eu.dnetlib.espas.spatial.QueryCRS;
import eu.dnetlib.espas.spatial.TimePeriodConstraint;
import eu.dnetlib.espas.spatial.utils.QueryDBUtils;
import eu.dnetlib.espas.util.GeometryMetadataHandler;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.joda.time.Period;
import org.xml.sax.SAXException;

/**
 *
 * @author gathanas
 */
public class NonPeriodicObservationFilter extends ObservationFilter {
   private static final int BATCH_LIST_QUOTA= 1000000;
   private boolean cancel =false;
   
   public NonPeriodicObservationFilter(TimePeriodCalculator timeCalculator, QueryDBUtils dBUtils, QShape spaceConstraint, TimePeriodConstraint timeConstraint, 
                                                                                                                          String userId, QueryCRS crs, String uniqQueryId) {
      super(dBUtils, timeConstraint, userId, crs, uniqQueryId, timeCalculator, spaceConstraint);
   }
 
      @Override
   public void cancel(){
       cancel=true;
   }

   public void execute(){
      Period estimatePeriod = timeCalculator.estimatePeriod(timeConstraint);
      List<Date[]> timePeriodPoints= timeCalculator.findPeriodicTimestamps(timeConstraint.getFromDate(), timeConstraint.getToDate(), estimatePeriod);
      filterNonPeriodicObservations(timePeriodPoints);
      performLocationQuery();
   }

   private void filterNonPeriodicObservations(List<Date[]> timePeriodPoints) {

      List<Object[]> filteredObservations = new LinkedList<Object[]>();
// todo : make the process iterative so as to avoid out of memory exceptions 
      int filteredObservationsSize = 0;
      List<Object[]> nonPeriodicStaticInstrumentObs =this.dBUtils.getNonPeriodicStaticInstrumentObs(this.timeConstraint.getFromDate(),this.timeConstraint.getToDate());
      for(Object[] observationRecord:nonPeriodicStaticInstrumentObs)
         for(Date[] timePeriod:timePeriodPoints)
             if(cancel){
                 return;
             }
          else{
            String locationXML=null;
            try {
                locationXML = GeometryMetadataHandler.transformGeoLocation(timePeriod[1],(String)observationRecord[4],crs.espasValue());
            } catch (IOException ex) {
               _logger.error(null, ex);
            } catch (JAXBException ex) {
               _logger.error(null, ex);
            } catch (ParseException ex) {
               _logger.error(null, ex);
            } catch (SAXException ex) {
               _logger.error(null, ex);
            }
            
            String obId = (String) observationRecord[0];
            if(locationXML!=null && !locationXML.isEmpty())
               filteredObservations.add(new Object[]{uniqQueryId, obId,timePeriod[0],timePeriod[2],locationXML});
            
//            batch cut-off filter
            if(filteredObservations.size()==BATCH_LIST_QUOTA){
                  _logger.debug("About to submit a batch of data to the db to avoid out of memory exceptions!");
                  this.dBUtils.registerFilteredObservations(uniqQueryId,SQueryObservationType.StaticNonPeriodic.name(),filteredObservations);
                  filteredObservationsSize += BATCH_LIST_QUOTA;
                  filteredObservations.clear();
            }
         }
      
      if(!cancel)
          this.dBUtils.registerFilteredObservations(uniqQueryId,SQueryObservationType.StaticNonPeriodic.name(),filteredObservations);
      _logger.info("\n\n Non periodic observation records is :"+(filteredObservations.size()+filteredObservationsSize));
   }
   
   @Override
   protected void performLocationQuery(){
   }
   
   
   
}

