/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial.impl;

import eu.dnetlib.espas.spatial.QShape;
import eu.dnetlib.espas.spatial.QueryCRS;
import eu.dnetlib.espas.spatial.TimePeriodConstraint;
import eu.dnetlib.espas.spatial.utils.QueryDBUtils;
import org.apache.log4j.Logger;

/**
 *
 * @author gathanas
 */
public abstract class ObservationFilter {
   
   protected static final Logger _logger = Logger.getLogger(NonPeriodicObservationFilter.class);
   protected QueryDBUtils dBUtils;
   protected TimePeriodConstraint timeConstraint;
   protected String userId;
   protected QueryCRS crs;
   protected String uniqQueryId;
   protected TimePeriodCalculator timeCalculator;
   protected QShape spaceConstraint;

   public ObservationFilter() {
   }

   public ObservationFilter(QueryDBUtils dBUtils, TimePeriodConstraint timeConstraint, String userId, QueryCRS crs, String uniqQueryId,
                            TimePeriodCalculator timeCalculator, QShape spaceConstraint) {
      this.dBUtils = dBUtils;
      this.timeConstraint = timeConstraint;
      this.userId = userId;
      this.crs = crs;
      this.uniqQueryId = uniqQueryId;
      this.timeCalculator = timeCalculator;
      this.spaceConstraint = spaceConstraint;
   }


   public abstract void cancel();
   public abstract void execute();

   protected abstract void performLocationQuery();
   
}
