/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.transformers.udfs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaUtil;

public class StringBagsMerger
extends EvalFunc<DataBag> {
    public DataBag exec(Tuple tuple) throws IOException {
        if (tuple == null || tuple.size() == 0) {
            return null;
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (int i = 0; i < tuple.size(); ++i) {
            if (tuple.get(i) == null) continue;
            DataBag db = (DataBag)tuple.get(i);
            for (Tuple next : db) {
                if (tuples.contains(next)) continue;
                tuples.add(next);
            }
        }
        if (tuples.isEmpty()) {
            return null;
        }
        BagFactory bagFactory = BagFactory.getInstance();
        return bagFactory.newDefaultBag((List)Lists.newArrayList(tuples));
    }

    public Schema outputSchema(Schema input) {
        try {
            return SchemaUtil.newBagSchema((List)Lists.newArrayList((Object[])new Byte[]{(byte)55}));
        }
        catch (FrontendException ex) {
            return null;
        }
    }
}

