define avro_load_document_to_research_initiative
org.apache.pig.piggybank.storage.avro.AvroStorage(
'input_schema_class', '$schema_input_document_to_research_initiative');

define avro_store_document_to_research_initiatives
org.apache.pig.piggybank.storage.avro.AvroStorage(
'index', '0',
'output_schema_class', '$schema_output_document_to_research_initiatives');

documentToResearchInitiative = load '$input_document_to_research_initiative' using avro_load_document_to_research_initiative;

researchInitiativeGroupped = group documentToResearchInitiative by documentId;
researchInitiative = foreach researchInitiativeGroupped {
    ids = foreach documentToResearchInitiative generate egiConceptId;
    generate group as documentId, ids as researchInitiativeConceptIds;
}

store researchInitiative into '$output_document_to_research_initiatives' using avro_store_document_to_research_initiatives;
