/**
 * Copyright 2008-2009 DRIVER PROJECT (Bielefeld University)
 * Original author: Marek Imialek <marek.imialek at uni-bielefeld.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.dnetlib.data.mdstore;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

import eu.dnetlib.common.ws.dataprov.IDataProvider;
import eu.dnetlib.common.interfaces.nh.INotificationHandler;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.ws.store.IMDRecordsStorage;

/**
 * Main Driver MDStore Service interface.
 * @author <a href="mailto:marek.imialek at uni-bielefeld.de">Marek Imialek</a>
 * @version 0.0.1  
 */

@WebService
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, 
		parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface IMDStoreService extends INotificationHandler, IDataProvider, IMDRecordsStorage {

	/**
	 * Identifies service and version.
	 * @return
	 */
	@WebMethod(operationName="identify", action="identify")
	public String identify();
	
	/**
	 * Returns ResultSet EPR for delivered mdstore records.
	 * TODO make sure that WebParam names are correct, according to wsdl which is apparently not specified yet
	 * @param mdId
	 * @param mdFormat
	 * @param from
	 * @param until
	 * @throws MDStoreServiceException
	 * @return ResultSet EPR 
	 */
	@WebMethod(operationName="deliverMDRecords", action="deliverMDRecords")
	public W3CEndpointReference deliverMDRecords(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="mdFormat") String mdFormat,
			@WebParam(name="from") String from,
			@WebParam(name="until") String until,
			@WebParam(name="recordsFilter") String recordFilter)
		throws MDStoreServiceException;
	
	/**
	 * Deliver single record from selected mdstore.
	 * @param mdId
	 * @param recordId
	 * @throws MDStoreServiceException
	 * @return record 
	 */
	@WebMethod(operationName="deliverRecord", action="deliverRecord")
	public String deliverRecord(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="recordId") String recordId)
		throws MDStoreServiceException;
	
	/**
	 * Deliver specified range of records from selected mdstore.
	 * The range is specified by the number of records
	 * @param mdId
	 * @param mdstoreRecordNumberFrom
	 * @param mdstoreRecordNumberTo
	 * @throws MDStoreServiceException
	 * @return records 
	 */
	@WebMethod(operationName="deliverMDRecordsDirect_Range", action="deliverMDRecordsDirect_Range")
	public List<String> deliverMDRecordsDirect_Range(
			@WebParam(name="mdId") String mdId, 
			@WebParam(name="mdstoreRecordNumberFrom") int mdstoreRecordNumberFrom,
			@WebParam(name="mdstoreRecordNumberTo") int mdstoreRecordNumberTo)
		throws MDStoreServiceException;
	
	/**
	 * Returns list of all stored indices.
	 * @return list of all stored indices
	 */
	@WebMethod(operationName="getListOfMDStores", action="getListOfMDStores")
	public List<String> getListOfMDStores();
	
	/**
	 * Returns list of all stored indices in CSV format.
	 * @return list of all stored indices in CSV format
	 */
	@WebMethod(operationName="getListOfMDStoresCSV", action="getListOfMDStoresCSV")
	public String getListOfMDStoresCSV();

    /**
	 * Merge md record keywords.
	 * 
	 * @param mdId
	 *            the md id
	 * @param recordId
	 *            the record id
	 * @param fieldName
	 *            the field name
	 * @param keywords
	 *            the keywords
	 * 
	 * @return true, if successful
	 * 
	 * @throws MDStoreServiceException
	 *             the MD store service exception
	 */
    @WebMethod(operationName="mergeMDRecordKeywords", action="mergeMDRecordKeywords")
	public boolean mergeMDRecordKeywords(
			@WebParam(name="mdId") String mdId,
			@WebParam(name="recordId") String recordId,
			@WebParam(name="fieldName") String fieldName,
			@WebParam(name="keywords") String keywords)
    	throws MDStoreServiceException;
}
