package eu.dnetlib.api.data;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.data.StoreInfo;
import eu.dnetlib.domain.data.StoreObjectInfo;

public interface StoreService extends DriverService {
	public enum StoringType {
		REFRESH("REFRESH"),
		INCREMENTAL("INCREMENTAL");
		
		private String value = null;
		
		private StoringType(String value) {
			this.value = value;
		}

		public String getValue() {
			return value;
		}
	}
	
	public enum DataType {
		DATA("DATA"),
		URL("URI");
		
		private String value = null;
		
		private DataType(String value) {
			this.value = value;
		}
		
		public String getValue() {
			return this.value;
		}
	}
	

	public StoreInfo createStore(List<String> predefinedObjectTypes,
			long maxSizeStoreDS) throws StoreServiceException;

	public boolean updateStore(String storeId, long maxSizeStoreDS,
			List<String> predefinedObjectTypes) throws StoreServiceException;

	public void deleteStore(String storeId) throws StoreServiceException;

	public List<StoreObjectInfo> storeObjects(String storeId, List<String> objectsForStoring,
			DataType dataType, StoringType storingType) throws StoreServiceException;

	public boolean deleteStoreObject(String storeId, List<String> storeObjectIds)
			throws StoreServiceException;

	public List<StoreObjectInfo> storeObjectsFromRS(String storeId, EPR rsEPR,
			DataType dataType, StoringType storingType) throws StoreServiceException;

	public boolean deleteStoreObjectFromRS(String storeId, EPR rsEPR)
			throws StoreServiceException;
}