package eu.dnetlib.api.enabling;

import java.util.List;

import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.actionmanager.common.Operation;
import eu.dnetlib.actionmanager.common.Provenance;
import eu.dnetlib.actionmanager.rmi.ActionManagerException;
import eu.dnetlib.actionmanager.set.ActionManagerSet;
import eu.dnetlib.api.DriverService;

public interface ActionManagerService extends DriverService {
	public String createSet(ActionManagerSet set) throws ActionManagerException;

	public List<ActionManagerSet> ListSets() throws ActionManagerException;

	public String createAction(
			String splitRuleId, 
			String set, 
			Agent agent,
			Operation operation, 
			String infoPackage, 
			Provenance provenance,
			String trust, 
			String nsprefix) throws ActionManagerException;

	public String updateAction(
			String actionId, 
			String splitRuleId, 
			String set,
			Agent agent, 
			Operation operation, 
			String infoPackage,
			Provenance provenance, 
			String trust, 
			String nsprefix) throws ActionManagerException;

	public boolean deleteAction(String actionId) throws ActionManagerException;

	public List<String> getActionsByAgent(String agentId, int limit)
			throws ActionManagerException;
}
