package eu.dnetlib.api.functionality;

import java.util.List;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.functionality.Post;
import eu.dnetlib.domain.functionality.Thread;

/**
 * This interface describes the available methods  of a forum service.
 * @author thanos@di.uoa.gr
 *
 */
public interface ForumService extends DriverService {
	/**
	 * Open a new thread.
	 * @param communityId the id of the community that the thread belongs to
	 * @param userId the id of the user that opens the thread
	 * @param topic the topic of the thread
	 * @return the id of the thread just opened
	 * @throws ForumServiceException if any errors occur
	 */
	public long openThread(String communityId, String userId, String topic) throws ForumServiceException;
	
	/**
	 * Edit an existing thread.
	 * @param threadId the id of the thread to edit
	 * @param topic the new topic of the thread
	 * @param posts the new posts of the thread
	 * @throws ForumServiceException if any errors occur
	 */
	public void editThread(long threadId, String topic, List<Post> posts) throws ForumServiceException;
	
	/**
	 * Delete an existing thread.
	 * @param threadId the id of the thread to delete
	 * @throws ForumServiceException if any errors occur
	 */
	public void deleteThread(long threadId) throws ForumServiceException;
	
	/**
	 * Search for an existing thread by id.
	 * @param threadId the id of the thread to search for
	 * @return the thread with the specified id or null if no such thread exists
	 * @throws ForumServiceException if any errors occur
	 */
	public Thread searchThread(long threadId) throws ForumServiceException;
	
	/**
	 * Search for existing threads by community.
	 * @param communityId the id of the community the threads belong to
	 * @return a list containing all the threads that belong to the specified community
	 * @throws ForumServiceException if any errors occur
	 */
	public List<Thread> searchThread(String communityId) throws ForumServiceException;
}
