package eu.dnetlib.api.functionality;

/**
 * This exception is thrown by notification service if any errors occur.
 * @author thanos@di.uoa.gr
 * @see NotificationService
 * 
 */
public class NotificationServiceException extends Exception {
	private static final long serialVersionUID = 1L;
	
	/**
	 * Construct a new notification service exception with the specified message and cause.
	 * @param message the message
	 * @param cause the cause
	 */
	public NotificationServiceException(final String message, final Throwable cause) {
		super(message, cause);
	}
	
	/**
	 * Construct a new notification service exception with the specified message.
	 * @param message the message
	 */
	public NotificationServiceException(final String message) {
		super(message);
	}
}
